/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.filter.IllegalFilterException;
import org.geotools.styling.Displacement;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.util.Cloneable;

public class DisplacementImpl
implements Displacement,
Cloneable {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.core");
    private FilterFactory filterFactory;
    private Expression displacementX = null;
    private Expression displacementY = null;

    public DisplacementImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public DisplacementImpl(FilterFactory factory) {
        this.filterFactory = factory;
        try {
            this.displacementX = this.filterFactory.literal(0);
            this.displacementY = this.filterFactory.literal(0);
        }
        catch (IllegalFilterException ife) {
            LOGGER.severe("Failed to build defaultDisplacement: " + ife);
        }
    }

    public DisplacementImpl(Expression dx, Expression dy) {
        this.filterFactory = CommonFactoryFinder.getFilterFactory2(null);
        this.displacementX = dx;
        this.displacementY = dy;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.filterFactory = factory;
        try {
            this.displacementX = this.filterFactory.literal(0);
            this.displacementY = this.filterFactory.literal(0);
        }
        catch (IllegalFilterException ife) {
            LOGGER.severe("Failed to build defaultDisplacement: " + ife);
        }
    }

    public void setDisplacementX(Expression displacementX) {
        this.displacementX = displacementX;
    }

    public void setDisplacementX(double displacementX) {
        this.displacementX = this.filterFactory.literal(displacementX);
    }

    public void setDisplacementY(Expression displacementY) {
        this.displacementY = displacementY;
    }

    public void setDisplacementY(double displacementY) {
        this.displacementY = this.filterFactory.literal(displacementY);
    }

    public Expression getDisplacementX() {
        return this.displacementX;
    }

    public Expression getDisplacementY() {
        return this.displacementY;
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Will not happen");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DisplacementImpl) {
            DisplacementImpl other = (DisplacementImpl)obj;
            return Utilities.equals(this.displacementX, other.displacementX) && Utilities.equals(this.displacementY, other.displacementY);
        }
        return false;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 17;
        if (this.displacementX != null) {
            result = result * 37 + this.displacementX.hashCode();
        }
        if (this.displacementY != null) {
            result = result * 37 + this.displacementY.hashCode();
        }
        return result;
    }

    static DisplacementImpl cast(org.opengis.style.Displacement displacement) {
        if (displacement == null) {
            return null;
        }
        if (displacement instanceof DisplacementImpl) {
            return (DisplacementImpl)displacement;
        }
        DisplacementImpl copy = new DisplacementImpl();
        copy.setDisplacementX(displacement.getDisplacementX());
        copy.setDisplacementY(displacement.getDisplacementY());
        return copy;
    }
}

