/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.util.List;
import org.geotools.referencing.datum.BursaWolfParameters;
import org.geotools.referencing.operation.builder.MappedPosition;
import org.geotools.referencing.operation.builder.MathTransformBuilder;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.transform.GeocentricTranslation;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.MathTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BursaWolfTransformBuilder
extends MathTransformBuilder {
    private GeodeticDatum targetDatum;
    GeneralMatrix x;
    GeneralMatrix X;
    private double alfa = 0.0;
    private double beta = 0.0;
    private double gamma = 0.0;
    private double dx = 0.0;
    private double dy = 0.0;
    private double dz = 0.0;
    private double q = 1.0;

    public BursaWolfTransformBuilder(List<MappedPosition> vectors) {
        super.setMappedPositions(vectors);
        this.x = new GeneralMatrix(vectors.size(), 3);
        this.X = new GeneralMatrix(vectors.size(), 3);
        this.x = this.getx();
        this.X = this.getX();
        this.getDxMatrix();
    }

    @Override
    public int getMinimumPointCount() {
        return 3;
    }

    @Override
    public int getDimension() {
        return 3;
    }

    public Class<? extends CartesianCS> getCoordinateSystemType() {
        return CartesianCS.class;
    }

    protected GeneralMatrix getx() {
        DirectPosition[] sourcePoints = this.getSourcePoints();
        GeneralMatrix x = new GeneralMatrix(3 * sourcePoints.length, 1);
        for (int j = 0; j < x.getNumRow(); j += 3) {
            x.setElement(j, 0, sourcePoints[j / 3].getCoordinates()[0]);
            x.setElement(j + 1, 0, sourcePoints[j / 3].getCoordinates()[1]);
            x.setElement(j + 2, 0, sourcePoints[j / 3].getCoordinates()[2]);
        }
        return x;
    }

    protected GeneralMatrix getX() {
        DirectPosition[] sourcePoints = this.getSourcePoints();
        DirectPosition[] targetPoints = this.getTargetPoints();
        GeneralMatrix X2 = new GeneralMatrix(3 * sourcePoints.length, 1);
        for (int j = 0; j < X2.getNumRow(); j += 3) {
            X2.setElement(j, 0, targetPoints[j / 3].getCoordinates()[0]);
            X2.setElement(j + 1, 0, targetPoints[j / 3].getCoordinates()[1]);
            X2.setElement(j + 2, 0, targetPoints[j / 3].getCoordinates()[2]);
        }
        return X2;
    }

    protected GeneralMatrix getRalfa() {
        GeneralMatrix Ralfa = new GeneralMatrix(3, 3);
        double[] m0 = new double[]{1.0, 0.0, 0.0};
        double[] m1 = new double[]{0.0, Math.cos(this.alfa), Math.sin(this.alfa)};
        double[] m2 = new double[]{0.0, -Math.sin(this.alfa), Math.cos(this.alfa)};
        Ralfa.setRow(0, m0);
        Ralfa.setRow(1, m1);
        Ralfa.setRow(2, m2);
        return Ralfa;
    }

    protected GeneralMatrix getRbeta() {
        GeneralMatrix Rbeta = new GeneralMatrix(3, 3);
        double[] m0 = new double[]{Math.cos(this.beta), 0.0, -Math.sin(this.beta)};
        double[] m1 = new double[]{0.0, 1.0, 0.0};
        double[] m2 = new double[]{Math.sin(this.beta), 0.0, Math.cos(this.beta)};
        Rbeta.setRow(0, m0);
        Rbeta.setRow(1, m1);
        Rbeta.setRow(2, m2);
        return Rbeta;
    }

    protected GeneralMatrix getRgamma() {
        GeneralMatrix Rgamma = new GeneralMatrix(3, 3);
        double[] m0 = new double[]{Math.cos(this.gamma), Math.sin(this.gamma), 0.0};
        double[] m1 = new double[]{-Math.sin(this.gamma), Math.cos(this.gamma), 0.0};
        double[] m2 = new double[]{0.0, 0.0, 1.0};
        Rgamma.setRow(0, m0);
        Rgamma.setRow(1, m1);
        Rgamma.setRow(2, m2);
        return Rgamma;
    }

    protected GeneralMatrix getDRalfa() {
        GeneralMatrix dRa = new GeneralMatrix(3, 3);
        double[] m0 = new double[]{0.0, 0.0, 0.0};
        double[] m1 = new double[]{0.0, -Math.sin(this.alfa), Math.cos(this.alfa)};
        double[] m2 = new double[]{0.0, -Math.cos(this.alfa), -Math.sin(this.alfa)};
        dRa.setRow(0, m0);
        dRa.setRow(1, m1);
        dRa.setRow(2, m2);
        dRa.mul(dRa, this.getRbeta());
        dRa.mul(dRa, this.getRgamma());
        return this.specialMul(dRa, this.x);
    }

    protected GeneralMatrix getDRbeta() {
        GeneralMatrix dRb = new GeneralMatrix(3, 3);
        double[] m0 = new double[]{-Math.sin(this.beta), 0.0, -Math.cos(this.beta)};
        double[] m1 = new double[]{0.0, 0.0, 0.0};
        double[] m2 = new double[]{Math.cos(this.beta), 0.0, -Math.sin(this.beta)};
        dRb.setRow(0, m0);
        dRb.setRow(1, m1);
        dRb.setRow(2, m2);
        dRb.mul(this.getRalfa(), dRb);
        dRb.mul(dRb, this.getRgamma());
        return this.specialMul(dRb, this.x);
    }

    protected GeneralMatrix getDRgamma() {
        GeneralMatrix dRg = new GeneralMatrix(3, 3);
        GeneralMatrix pom = new GeneralMatrix(3, 3);
        double[] m0 = new double[]{-Math.sin(this.gamma), Math.cos(this.gamma), 0.0};
        double[] m1 = new double[]{-Math.cos(this.gamma), -Math.sin(this.gamma), 0.0};
        double[] m2 = new double[]{0.0, 0.0, 0.0};
        dRg.setRow(0, m0);
        dRg.setRow(1, m1);
        dRg.setRow(2, m2);
        pom.mul(this.getRalfa(), this.getRbeta());
        dRg.mul(pom, dRg);
        return this.specialMul(dRg, this.x);
    }

    protected GeneralMatrix getDq() {
        GeneralMatrix R = new GeneralMatrix(3, 3);
        R.mul(this.getRalfa(), this.getRbeta());
        R.mul(R, this.getRgamma());
        return this.specialMul(R, this.x);
    }

    protected GeneralMatrix getl() {
        GeneralMatrix l = new GeneralMatrix(3 * this.getMappedPositions().size(), 1);
        GeneralMatrix R = new GeneralMatrix(3, 3);
        GeneralMatrix T = new GeneralMatrix(3, 1, new double[]{-this.dx, -this.dy, -this.dz});
        GeneralMatrix qMatrix = new GeneralMatrix(1, 1, new double[]{this.q});
        GeneralMatrix qx = new GeneralMatrix(this.X.getNumRow(), this.X.getNumCol());
        qx.mul(this.x, qMatrix);
        R.mul(this.getRalfa(), this.getRbeta());
        R.mul(this.getRgamma());
        l.sub(this.specialMul(R, qx), this.X);
        l = this.specialSub(T, l);
        return l;
    }

    protected GeneralMatrix specialMul(GeneralMatrix R, GeneralMatrix x) {
        GeneralMatrix dRx = new GeneralMatrix(3 * this.getMappedPositions().size(), 1);
        for (int i = 0; i < x.getNumRow(); i += 3) {
            GeneralMatrix subMatrix = new GeneralMatrix(3, 1);
            x.copySubMatrix(i, 0, 3, 1, 0, 0, subMatrix);
            subMatrix.mul(R, subMatrix);
            subMatrix.copySubMatrix(0, 0, 3, 1, i, 0, dRx);
        }
        return dRx;
    }

    private GeneralMatrix specialSub(GeneralMatrix R, GeneralMatrix x) {
        GeneralMatrix dRx = new GeneralMatrix(3 * this.getMappedPositions().size(), 1);
        for (int i = 0; i < x.getNumRow(); i += 3) {
            GeneralMatrix subMatrix = new GeneralMatrix(3, 1);
            x.copySubMatrix(i, 0, 3, 1, 0, 0, subMatrix);
            subMatrix.sub(R, subMatrix);
            subMatrix.copySubMatrix(0, 0, 3, 1, i, 0, dRx);
        }
        return dRx;
    }

    protected GeneralMatrix getA() {
        int size = this.getMappedPositions().size();
        GeneralMatrix A = new GeneralMatrix(3 * size, 7);
        GeneralMatrix DT = new GeneralMatrix(3, 3);
        double[] m0 = new double[]{1.0, 0.0, 0.0};
        double[] m1 = new double[]{0.0, 1.0, 0.0};
        double[] m2 = new double[]{0.0, 0.0, 1.0};
        DT.setRow(0, m0);
        DT.setRow(1, m1);
        DT.setRow(2, m2);
        for (int i = 0; i < A.getNumRow(); i += 3) {
            DT.copySubMatrix(0, 0, 3, 3, i, 0, A);
        }
        this.getDRalfa().copySubMatrix(0, 0, 3 * size, 1, 0, 3, A);
        this.getDRbeta().copySubMatrix(0, 0, 3 * size, 1, 0, 4, A);
        this.getDRgamma().copySubMatrix(0, 0, 3 * size, 1, 0, 5, A);
        this.getDq().copySubMatrix(0, 0, 3 * size, 1, 0, 6, A);
        return A;
    }

    protected double[] getParameters() {
        return this.getDxMatrix().getElements()[0];
    }

    public GeneralMatrix getDxMatrix() {
        return this.getDxMatrix(1.0E-8, 20);
    }

    private GeneralMatrix getDxMatrix(double tolerance, int maxSteps) {
        GeneralMatrix xNew = new GeneralMatrix(7, 1);
        GeneralMatrix xOld = new GeneralMatrix(7, 1);
        GeneralMatrix dxMatrix = new GeneralMatrix(7, 1);
        GeneralMatrix zero = new GeneralMatrix(7, 1);
        zero.setZero();
        int i = 0;
        do {
            xOld.set(new double[]{this.dx, this.dy, this.dz, this.alfa, this.beta, this.gamma, this.q});
            GeneralMatrix A = this.getA();
            GeneralMatrix l = this.getl();
            GeneralMatrix AT = A.clone();
            AT.transpose();
            GeneralMatrix ATA = new GeneralMatrix(7, 7);
            GeneralMatrix ATl = new GeneralMatrix(7, 1);
            ATA.mul(AT, A);
            ATA.invert();
            ATl.mul(AT, l);
            dxMatrix.mul(ATA, ATl);
            xOld.negate();
            xNew.sub(dxMatrix, xOld);
            this.dx = xNew.getElement(0, 0);
            this.dy = xNew.getElement(1, 0);
            this.dz = xNew.getElement(2, 0);
            this.alfa = xNew.getElement(3, 0);
            this.beta = xNew.getElement(4, 0);
            this.gamma = xNew.getElement(5, 0);
            this.q = xNew.getElement(6, 0);
        } while (!dxMatrix.equals(zero, tolerance) & ++i < maxSteps);
        xNew.transpose();
        return xNew;
    }

    private static double radiansToSeconds(double rad) {
        return rad * 57.29577951308232 * 3600.0;
    }

    public BursaWolfParameters getBursaWolfParameters(GeodeticDatum Datum2) {
        BursaWolfParameters parameters = new BursaWolfParameters(Datum2);
        parameters.dx = this.dx;
        parameters.dy = this.dy;
        parameters.dz = this.dz;
        parameters.ex = -BursaWolfTransformBuilder.radiansToSeconds(this.alfa);
        parameters.ey = -BursaWolfTransformBuilder.radiansToSeconds(this.beta);
        parameters.ez = -BursaWolfTransformBuilder.radiansToSeconds(this.gamma);
        parameters.ppm = (this.q - 1.0) * 1000000.0;
        return parameters;
    }

    public void setTargetGeodeticDatum(GeodeticDatum gd) {
        this.targetDatum = gd;
    }

    @Override
    protected MathTransform computeMathTransform() throws FactoryException {
        return new GeocentricTranslation(this.getBursaWolfParameters(this.targetDatum));
    }
}

