/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.datum.AbstractDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTemporalDatum
extends AbstractDatum
implements TemporalDatum {
    private static final long serialVersionUID = 3357241732140076884L;
    public static final DefaultTemporalDatum JULIAN = new DefaultTemporalDatum(DefaultTemporalDatum.name(117), new Date(-210866760000000L));
    public static final DefaultTemporalDatum MODIFIED_JULIAN = new DefaultTemporalDatum(DefaultTemporalDatum.name(142), new Date(-3506716800000L));
    public static final DefaultTemporalDatum TRUNCATED_JULIAN = new DefaultTemporalDatum(DefaultTemporalDatum.name(227), new Date(-50716800000L));
    public static final DefaultTemporalDatum DUBLIN_JULIAN = new DefaultTemporalDatum(DefaultTemporalDatum.name(51), new Date(-2209032000000L));
    public static final DefaultTemporalDatum UNIX = new DefaultTemporalDatum("UNIX", new Date(0L));
    private final long origin;

    public DefaultTemporalDatum(TemporalDatum datum) {
        super(datum);
        this.origin = datum.getOrigin().getTime();
    }

    public DefaultTemporalDatum(String name, Date origin) {
        this(Collections.singletonMap("name", name), origin);
    }

    public DefaultTemporalDatum(Map<String, ?> properties, Date origin) {
        super(properties);
        DefaultTemporalDatum.ensureNonNull("origin", origin);
        this.origin = origin.getTime();
    }

    @Override
    public Date getOrigin() {
        return new Date(this.origin);
    }

    @Override
    public InternationalString getAnchorPoint() {
        return super.getAnchorPoint();
    }

    @Override
    public Date getRealizationEpoch() {
        return super.getRealizationEpoch();
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultTemporalDatum that = (DefaultTemporalDatum)object;
            return this.origin == that.origin;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (int)this.origin ^ (int)(this.origin >>> 32);
    }
}

