/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.identification;

import java.util.Collection;
import org.geotools.metadata.iso.MetadataEntity;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.identification.AggregateInformation;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.Keywords;
import org.opengis.metadata.identification.Progress;
import org.opengis.metadata.identification.Usage;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentificationImpl
extends MetadataEntity
implements Identification {
    private static final long serialVersionUID = -3715084806249419137L;
    private Citation citation;
    private InternationalString abstracts;
    private InternationalString purpose;
    private Collection<String> credits;
    private Collection<Progress> status;
    private Collection<ResponsibleParty> pointOfContacts;
    private Collection<MaintenanceInformation> resourceMaintenance;
    private Collection<BrowseGraphic> graphicOverviews;
    private Collection<Format> resourceFormat;
    private Collection<Keywords> descriptiveKeywords;
    private Collection<Usage> resourceSpecificUsages;
    private Collection<Constraints> resourceConstraints;
    private Collection<AggregateInformation> aggregationInfo;

    public IdentificationImpl() {
    }

    public IdentificationImpl(Identification source) {
        super(source);
    }

    public IdentificationImpl(Citation citation, InternationalString abstracts) {
        this.setCitation(citation);
        this.setAbstract(abstracts);
    }

    @Override
    public Citation getCitation() {
        return this.citation;
    }

    public synchronized void setCitation(Citation newValue) {
        this.checkWritePermission();
        this.citation = newValue;
    }

    @Override
    public InternationalString getAbstract() {
        return this.abstracts;
    }

    public synchronized void setAbstract(InternationalString newValue) {
        this.checkWritePermission();
        this.abstracts = newValue;
    }

    @Override
    public InternationalString getPurpose() {
        return this.purpose;
    }

    public synchronized void setPurpose(InternationalString newValue) {
        this.checkWritePermission();
        this.purpose = newValue;
    }

    @Override
    public synchronized Collection<String> getCredits() {
        this.credits = this.nonNullCollection(this.credits, String.class);
        return this.credits;
    }

    public synchronized void setCredits(Collection<? extends String> newValues) {
        this.credits = this.copyCollection(newValues, this.credits, String.class);
    }

    @Override
    public synchronized Collection<Progress> getStatus() {
        this.status = this.nonNullCollection(this.status, Progress.class);
        return this.status;
    }

    public synchronized void setStatus(Collection<? extends Progress> newValues) {
        this.status = this.copyCollection(newValues, this.status, Progress.class);
    }

    public synchronized Collection<ResponsibleParty> getPointOfContacts() {
        this.pointOfContacts = this.nonNullCollection(this.pointOfContacts, ResponsibleParty.class);
        return this.pointOfContacts;
    }

    public synchronized void setPointOfContacts(Collection<? extends ResponsibleParty> newValues) {
        this.pointOfContacts = this.copyCollection(newValues, this.pointOfContacts, ResponsibleParty.class);
    }

    public synchronized Collection<MaintenanceInformation> getResourceMaintenance() {
        this.resourceMaintenance = this.nonNullCollection(this.resourceMaintenance, MaintenanceInformation.class);
        return this.resourceMaintenance;
    }

    public synchronized void setResourceMaintenance(Collection<? extends MaintenanceInformation> newValues) {
        this.resourceMaintenance = this.copyCollection(newValues, this.resourceMaintenance, MaintenanceInformation.class);
    }

    public synchronized Collection<BrowseGraphic> getGraphicOverviews() {
        this.graphicOverviews = this.nonNullCollection(this.graphicOverviews, BrowseGraphic.class);
        return this.graphicOverviews;
    }

    public synchronized void setGraphicOverviews(Collection<? extends BrowseGraphic> newValues) {
        this.graphicOverviews = this.copyCollection(newValues, this.graphicOverviews, BrowseGraphic.class);
    }

    public synchronized Collection<Format> getResourceFormat() {
        this.resourceFormat = this.nonNullCollection(this.resourceFormat, Format.class);
        return this.resourceFormat;
    }

    public synchronized void setResourceFormat(Collection<? extends Format> newValues) {
        this.resourceFormat = this.copyCollection(newValues, this.resourceFormat, Format.class);
    }

    public synchronized Collection<Keywords> getDescriptiveKeywords() {
        this.descriptiveKeywords = this.nonNullCollection(this.descriptiveKeywords, Keywords.class);
        return this.descriptiveKeywords;
    }

    public synchronized void setDescriptiveKeywords(Collection<? extends Keywords> newValues) {
        this.descriptiveKeywords = this.copyCollection(newValues, this.descriptiveKeywords, Keywords.class);
    }

    public synchronized Collection<Usage> getResourceSpecificUsages() {
        this.resourceSpecificUsages = this.nonNullCollection(this.resourceSpecificUsages, Usage.class);
        return this.resourceSpecificUsages;
    }

    public synchronized void setResourceSpecificUsages(Collection<? extends Usage> newValues) {
        this.resourceSpecificUsages = this.copyCollection(newValues, this.resourceSpecificUsages, Usage.class);
    }

    public synchronized Collection<Constraints> getResourceConstraints() {
        this.resourceConstraints = this.nonNullCollection(this.resourceConstraints, Constraints.class);
        return this.resourceConstraints;
    }

    public synchronized void setResourceConstraints(Collection<? extends Constraints> newValues) {
        this.resourceConstraints = this.copyCollection(newValues, this.resourceConstraints, Constraints.class);
    }

    public synchronized Collection<AggregateInformation> getAggregationInfo() {
        this.aggregationInfo = this.nonNullCollection(this.aggregationInfo, AggregateInformation.class);
        return this.aggregationInfo;
    }

    public synchronized void setAggregationInfo(Collection<? extends AggregateInformation> newValues) {
        this.aggregationInfo = this.copyCollection(newValues, this.aggregationInfo, AggregateInformation.class);
    }
}

