/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import java.io.Serializable;
import java.text.Format;
import java.text.ParseException;
import java.util.Locale;
import org.geotools.measure.AngleFormat;
import org.geotools.resources.ClassChanger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Angle
implements Comparable<Angle>,
Serializable {
    private static final long serialVersionUID = 1158747349433104534L;
    private static Format format;
    private final double theta;

    public Angle(double theta) {
        this.theta = theta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Angle(String string) throws NumberFormatException {
        Angle theta;
        Format format = Angle.getAngleFormat();
        try {
            Class<Angle> clazz = Angle.class;
            synchronized (Angle.class) {
                theta = (Angle)format.parseObject(string);
                // ** MonitorExit[var4_3] (shouldn't be in output)
            }
        }
        catch (ParseException exception) {
            NumberFormatException e = new NumberFormatException(exception.getLocalizedMessage());
            e.initCause(exception);
            throw e;
        }
        {
            if (!this.getClass().isAssignableFrom(theta.getClass())) {
                throw new NumberFormatException(string);
            }
            this.theta = theta.theta;
            return;
        }
    }

    public double degrees() {
        return this.theta;
    }

    public double radians() {
        return Math.toRadians(this.theta);
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.theta);
        return (int)code ^ (int)(code >>> 32);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && this.getClass().equals(object.getClass())) {
            Angle that = (Angle)object;
            return Double.doubleToLongBits(this.theta) == Double.doubleToLongBits(that.theta);
        }
        return false;
    }

    @Override
    public int compareTo(Angle that) {
        return Double.compare(this.theta, that.theta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Class<Angle> clazz = Angle.class;
        synchronized (Angle.class) {
            Format format = Angle.getAngleFormat();
            buffer = format.format(this, buffer, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return buffer.toString();
        }
    }

    private static Format getAngleFormat() {
        assert (Thread.holdsLock(Angle.class));
        if (format == null) {
            format = new AngleFormat("D\u00b0MM.m'", Locale.US);
        }
        return format;
    }

    static {
        ClassChanger.register(new ClassChanger<Angle, Double>(Angle.class, Double.class){

            @Override
            protected Double convert(Angle o) {
                return o.theta;
            }

            @Override
            protected Angle inverseConvert(Double value) {
                return new Angle(value);
            }
        });
    }
}

