/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequenceFactory;
import java.util.ArrayList;
import java.util.List;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeometryCollector {
    List<Geometry> geometries = new ArrayList<Geometry>();
    GeometryFactory factory = new GeometryFactory(new PackedCoordinateSequenceFactory());
    long coordinates = 0L;
    long maxCoordinates = -1L;
    CoordinateReferenceSystem crs = null;
    int srid = -1;

    public long getMaxCoordinates() {
        return this.maxCoordinates;
    }

    public void setMaxCoordinates(long maxCoordinates) {
        this.maxCoordinates = maxCoordinates;
    }

    public GeometryFactory getFactory() {
        return this.factory;
    }

    public void setFactory(GeometryFactory factory) {
        this.factory = factory;
    }

    public GeometryCollection collect() {
        GeometryCollection gc = this.collectInternal();
        if (this.srid > 0) {
            gc.setSRID(this.srid);
        }
        if (this.crs != null) {
            gc.setUserData(this.crs);
        }
        return gc;
    }

    public GeometryCollection collectInternal() {
        Class collectionClass;
        if (this.geometries.isEmpty()) {
            return new GeometryCollection(null, this.factory == null ? new GeometryFactory() : this.factory);
        }
        GeometryFactory gf = this.factory;
        if (gf == null) {
            gf = this.geometries.get(0).getFactory();
        }
        if (gf == null) {
            gf = new GeometryFactory();
        }
        if ((collectionClass = this.guessCollectionType()) == MultiPoint.class) {
            Point[] array = this.geometries.toArray(new Point[this.geometries.size()]);
            return gf.createMultiPoint(array);
        }
        if (collectionClass == MultiPolygon.class) {
            Polygon[] array = this.geometries.toArray(new Polygon[this.geometries.size()]);
            return gf.createMultiPolygon(array);
        }
        if (collectionClass == MultiLineString.class) {
            LineString[] array = this.geometries.toArray(new LineString[this.geometries.size()]);
            return gf.createMultiLineString(array);
        }
        Geometry[] array = this.geometries.toArray(new Geometry[this.geometries.size()]);
        return gf.createGeometryCollection(array);
    }

    private Class guessCollectionType() {
        if (this.geometries == null || this.geometries.size() == 0) {
            return GeometryCollection.class;
        }
        Class result = this.baseType(this.geometries.get(0).getClass());
        for (int i = 1; i < this.geometries.size(); ++i) {
            Class<?> curr = this.geometries.get(i).getClass();
            if (curr == result || result.isAssignableFrom(curr)) continue;
            return GeometryCollection.class;
        }
        if (result == Point.class) {
            return MultiPoint.class;
        }
        if (result == LineString.class) {
            return MultiLineString.class;
        }
        if (result == Polygon.class) {
            return MultiPolygon.class;
        }
        return GeometryCollection.class;
    }

    private Class baseType(Class geometry) {
        if (Polygon.class.isAssignableFrom(geometry)) {
            return Polygon.class;
        }
        if (LineString.class.isAssignableFrom(geometry)) {
            return LineString.class;
        }
        if (Point.class.isAssignableFrom(geometry)) {
            return Point.class;
        }
        return geometry;
    }

    public void add(Geometry g) {
        if (g == null) {
            return;
        }
        this.initCRS(g);
        if (g instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                this.add(gc.getGeometryN(i));
            }
        } else {
            this.coordinates += (long)g.getNumPoints();
            if (this.maxCoordinates > 0L && this.coordinates > this.maxCoordinates) {
                throw new IllegalStateException("Max number of collected ordinates has been exceeded. Current count is " + this.coordinates + ", max count is " + this.maxCoordinates);
            }
            if (this.factory != null) {
                g = this.factory.createGeometry(g);
            }
            this.geometries.add(g);
        }
    }

    private void initCRS(Geometry g) {
        if (this.crs == null && g.getUserData() instanceof CoordinateReferenceSystem) {
            this.crs = (CoordinateReferenceSystem)g.getUserData();
        }
        if (this.srid == -1 && g.getSRID() > 0) {
            this.srid = g.getSRID();
        }
    }
}

