/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.AbstractFilterImpl;
import org.geotools.filter.Expression;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilter;
import org.opengis.filter.FilterVisitor;

public class LikeFilterImpl
extends AbstractFilterImpl
implements LikeFilter {
    private Expression attribute = null;
    private String pattern = null;
    private String wildcardSingle = ".?";
    private String wildcardMulti = ".*";
    private String escape = "\\";
    private Pattern compPattern = null;
    boolean matchingCase;

    public static String convertToSQL92(char escape, char multi, char single, boolean matchCase, String pattern) throws IllegalArgumentException {
        if (escape == '\'' || multi == '\'' || single == '\'') {
            throw new IllegalArgumentException("do not use single quote (') as special char!");
        }
        StringBuffer result = new StringBuffer(pattern.length() + 5);
        for (int i = 0; i < pattern.length(); ++i) {
            char chr = pattern.charAt(i);
            if (chr == escape) {
                if (i != pattern.length() - 1) {
                    result.append(pattern.charAt(i + 1));
                }
                ++i;
                continue;
            }
            if (chr == single) {
                result.append('_');
                continue;
            }
            if (chr == multi) {
                result.append('%');
                continue;
            }
            if (chr == '\'') {
                result.append('\'');
                result.append('\'');
                continue;
            }
            result.append(matchCase ? chr : Character.toUpperCase(chr));
        }
        return result.toString();
    }

    public String getSQL92LikePattern() throws IllegalArgumentException {
        if (this.escape.length() != 1) {
            throw new IllegalArgumentException("Like Pattern --> escape char should be of length exactly 1");
        }
        if (this.wildcardSingle.length() != 1) {
            throw new IllegalArgumentException("Like Pattern --> wildcardSingle char should be of length exactly 1");
        }
        if (this.wildcardMulti.length() != 1) {
            throw new IllegalArgumentException("Like Pattern --> wildcardMulti char should be of length exactly 1");
        }
        return LikeFilterImpl.convertToSQL92(this.escape.charAt(0), this.wildcardMulti.charAt(0), this.wildcardSingle.charAt(0), this.matchingCase, this.pattern);
    }

    public void setWildCard(String wildCard) {
        this.wildcardMulti = wildCard;
        this.compPattern = null;
    }

    public void setSingleChar(String singleChar) {
        this.wildcardSingle = singleChar;
        this.compPattern = null;
    }

    public void setEscape(String escape) {
        this.escape = escape;
        this.compPattern = null;
    }

    public void setMatchCase(boolean matchingCase) {
        this.matchingCase = matchingCase;
        this.compPattern = null;
    }

    public boolean isMatchingCase() {
        return this.matchingCase;
    }

    public void setMatchingCase(boolean matchingCase) {
        this.matchingCase = matchingCase;
    }

    private Matcher getMatcher(String string) {
        if (this.compPattern == null) {
            String pattern1 = new String(this.pattern);
            String wildcardMulti1 = new String(this.wildcardMulti);
            String wildcardSingle1 = new String(this.wildcardSingle);
            String escape1 = new String(this.escape);
            char esc = escape1.charAt(0);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("wildcard " + wildcardMulti1 + " single " + wildcardSingle1);
                LOGGER.finer("escape " + escape1 + " esc " + esc + " esc == \\ " + (esc == '\\'));
            }
            String escapedWildcardMulti = this.fixSpecials(wildcardMulti1);
            String escapedWildcardSingle = this.fixSpecials(wildcardSingle1);
            StringBuffer tmp = new StringBuffer("");
            boolean escapedMode = false;
            for (int i = 0; i < pattern1.length(); ++i) {
                char chr = pattern1.charAt(i);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("tmp = " + tmp + " looking at " + chr);
                }
                if (pattern1.regionMatches(false, i, escape1, 0, escape1.length())) {
                    LOGGER.finer("escape ");
                    escapedMode = true;
                    chr = pattern1.charAt(i += escape1.length());
                }
                if (pattern1.regionMatches(false, i, wildcardMulti1, 0, wildcardMulti1.length())) {
                    LOGGER.finer("multi wildcard");
                    if (escapedMode) {
                        LOGGER.finer("escaped ");
                        tmp.append(escapedWildcardMulti);
                    } else {
                        tmp.append(".*");
                    }
                    i += wildcardMulti1.length() - 1;
                    escapedMode = false;
                    continue;
                }
                if (pattern1.regionMatches(false, i, wildcardSingle1, 0, wildcardSingle1.length())) {
                    LOGGER.finer("single wildcard");
                    if (escapedMode) {
                        LOGGER.finer("escaped ");
                        tmp.append(escapedWildcardSingle);
                    } else {
                        tmp.append(".{1}");
                    }
                    i += wildcardSingle1.length() - 1;
                    escapedMode = false;
                    continue;
                }
                if (this.isSpecial(chr)) {
                    LOGGER.finer("special");
                    tmp.append(this.escape + chr);
                    escapedMode = false;
                    continue;
                }
                tmp.append(chr);
                escapedMode = false;
            }
            pattern1 = tmp.toString();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("final pattern " + pattern1);
            }
            this.compPattern = this.isMatchingCase() ? Pattern.compile(pattern1) : Pattern.compile(pattern1, 2);
        }
        return this.compPattern.matcher(string);
    }

    protected LikeFilterImpl() {
        super(CommonFactoryFinder.getFilterFactory(null));
        this.filterType = (short)20;
    }

    public LikeFilterImpl(org.opengis.filter.expression.Expression expr, String pattern, String wildcardMulti, String wildcardSingle, String escape) {
        this();
        this.setExpression(expr);
        this.setLiteral(pattern);
        this.setWildCard(wildcardMulti);
        this.setSingleChar(wildcardSingle);
        this.setEscape(escape);
    }

    public final void setValue(Expression attribute) throws IllegalFilterException {
        this.setExpression(attribute);
    }

    public final Expression getValue() {
        return this.attribute;
    }

    public org.opengis.filter.expression.Expression getExpression() {
        return this.getValue();
    }

    public void setExpression(org.opengis.filter.expression.Expression e) {
        Expression attribute = (Expression)e;
        if (attribute.getType() == 111 && !this.permissiveConstruction) {
            throw new IllegalFilterException("Attempted to add something other than a string attribute expression to a like filter.");
        }
        this.attribute = attribute;
    }

    public final void setPattern(Expression p, String wildcardMulti, String wildcardSingle, String escape) {
        this.setPattern(p.toString(), wildcardMulti, wildcardSingle, escape);
    }

    public final void setPattern(String pattern, String wildcardMulti, String wildcardSingle, String escape) {
        this.setLiteral(pattern);
        this.setWildCard(wildcardMulti);
        this.setSingleChar(wildcardSingle);
        this.setEscape(escape);
    }

    public final String getPattern() {
        return this.getLiteral();
    }

    public String getLiteral() {
        return this.pattern;
    }

    public void setLiteral(String literal) {
        this.pattern = literal;
        this.compPattern = null;
    }

    public boolean evaluate(Object feature) {
        if (this.attribute == null) {
            return false;
        }
        Object value = this.attribute.evaluate(feature);
        if (null == value) {
            return false;
        }
        Matcher matcher = this.getMatcher(value.toString());
        return matcher.matches();
    }

    public String toString() {
        return "[ " + this.attribute.toString() + " is like " + this.pattern + " ]";
    }

    public String getEscape() {
        return this.escape;
    }

    public final String getWildcardMulti() {
        return this.wildcardMulti;
    }

    public String getWildCard() {
        return this.getWildcardMulti();
    }

    public final String getWildcardSingle() {
        return this.wildcardSingle;
    }

    public String getSingleChar() {
        return this.getWildcardSingle();
    }

    private boolean isSpecial(char chr) {
        return chr == '.' || chr == '?' || chr == '*' || chr == '^' || chr == '$' || chr == '+' || chr == '[' || chr == ']' || chr == '(' || chr == ')' || chr == '|' || chr == '\\' || chr == '&';
    }

    private String fixSpecials(String inString) {
        StringBuffer tmp = new StringBuffer("");
        for (int i = 0; i < inString.length(); ++i) {
            char chr = inString.charAt(i);
            if (this.isSpecial(chr)) {
                tmp.append(this.escape + chr);
                continue;
            }
            tmp.append(chr);
        }
        return tmp.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LikeFilterImpl) {
            LikeFilterImpl lFilter = (LikeFilterImpl)obj;
            return lFilter.getFilterType() == this.filterType && lFilter.getValue().equals(this.attribute) && lFilter.getPattern().equals(this.pattern);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.attribute == null ? 0 : this.attribute.hashCode());
        result = 37 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        return result;
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit(this, extraData);
    }
}

