/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Geometry;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.filter.LengthFunction;
import org.geotools.geometry.jts.JTS;
import org.geotools.util.Utilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.type.PropertyType;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureTypes {
    public static final URI DEFAULT_NAMESPACE;
    public static final SimpleFeatureType ABSTRACT_FEATURE_TYPE;
    public static final NameImpl DEFAULT_TYPENAME;
    public static final int ANY_LENGTH = -1;
    public static final SimpleFeatureType EMPTY;

    public static int getFieldLength(PropertyDescriptor descriptor) {
        Integer length = null;
        for (PropertyType type = descriptor.getType(); type != null; type = type.getSuper()) {
            for (Filter f : type.getRestrictions()) {
                Integer filterLength = null;
                try {
                    BinaryComparisonOperator cf;
                    if (f == null) continue;
                    if (f instanceof PropertyIsLessThan) {
                        cf = (BinaryComparisonOperator)f;
                        if (cf.getExpression1() instanceof LengthFunction) {
                            filterLength = cf.getExpression2().evaluate(null, Integer.class) - 1;
                        }
                    } else if (f instanceof PropertyIsLessThanOrEqualTo) {
                        cf = (BinaryComparisonOperator)f;
                        if (cf.getExpression1() instanceof LengthFunction) {
                            filterLength = cf.getExpression2().evaluate(null, Integer.class);
                        }
                    } else if (f instanceof PropertyIsGreaterThan) {
                        cf = (BinaryComparisonOperator)f;
                        if (cf.getExpression2() instanceof LengthFunction) {
                            filterLength = cf.getExpression1().evaluate(null, Integer.class) - 1;
                        }
                    } else if (f instanceof PropertyIsGreaterThanOrEqualTo && (cf = (BinaryComparisonOperator)f).getExpression2() instanceof LengthFunction) {
                        filterLength = cf.getExpression1().evaluate(null, Integer.class);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                if (filterLength == null || length != null && filterLength >= length) continue;
                length = filterLength;
            }
        }
        return length != null ? length : -1;
    }

    public static SimpleFeatureType transform(SimpleFeatureType schema, CoordinateReferenceSystem crs) throws SchemaException {
        return FeatureTypes.transform(schema, crs, false);
    }

    public static SimpleFeatureType transform(SimpleFeatureType schema, CoordinateReferenceSystem crs, boolean forceOnlyMissing) throws SchemaException {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(schema.getTypeName());
        tb.setNamespaceURI(schema.getName().getNamespaceURI());
        tb.setAbstract(schema.isAbstract());
        Object defaultGeometryType = null;
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            AttributeDescriptor attributeType = schema.getDescriptor(i);
            if (attributeType instanceof GeometryDescriptor) {
                GeometryDescriptor geometryType = (GeometryDescriptor)attributeType;
                tb.descriptor(geometryType);
                if (!forceOnlyMissing || geometryType.getCoordinateReferenceSystem() == null) {
                    tb.crs(crs);
                }
                tb.add(geometryType.getLocalName(), geometryType.getType().getBinding());
                continue;
            }
            tb.add(attributeType);
        }
        if (schema.getGeometryDescriptor() != null) {
            tb.setDefaultGeometry(schema.getGeometryDescriptor().getLocalName());
        }
        tb.setSuperType((SimpleFeatureType)schema.getSuper());
        return tb.buildFeatureType();
    }

    public static SimpleFeature transform(SimpleFeature feature, SimpleFeatureType schema, MathTransform transform) throws MismatchedDimensionException, TransformException, IllegalAttributeException {
        feature = SimpleFeatureBuilder.copy(feature);
        GeometryDescriptor geomType = schema.getGeometryDescriptor();
        Geometry geom = (Geometry)feature.getAttribute(geomType.getLocalName());
        geom = JTS.transform(geom, transform);
        feature.setAttribute(geomType.getLocalName(), (Object)geom);
        return feature;
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] types, String name, URI ns, boolean isAbstract, SimpleFeatureType[] superTypes) throws FactoryRegistryException, SchemaException {
        return FeatureTypes.newFeatureType(types, name, ns, isAbstract, superTypes, null);
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] types, String name, URI ns, boolean isAbstract, SimpleFeatureType[] superTypes, AttributeDescriptor defaultGeometry) throws FactoryRegistryException, SchemaException {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(name);
        tb.setNamespaceURI(ns);
        tb.setAbstract(isAbstract);
        if (types != null) {
            tb.addAll(types);
        }
        if (defaultGeometry != null) {
            boolean add = true;
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != defaultGeometry) continue;
                add = false;
                break;
            }
            if (add) {
                tb.add(defaultGeometry);
            }
            tb.setDefaultGeometry(defaultGeometry.getLocalName());
        }
        if (superTypes != null && superTypes.length > 0) {
            if (superTypes.length > 1) {
                throw new SchemaException("Can only specify a single super type");
            }
            tb.setSuperType(superTypes[0]);
        } else {
            tb.setSuperType(ABSTRACT_FEATURE_TYPE);
        }
        return tb.buildFeatureType();
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] types, String name, URI ns, boolean isAbstract, SimpleFeatureType[] superTypes, GeometryDescriptor defaultGeometry) throws FactoryRegistryException, SchemaException {
        return FeatureTypes.newFeatureType(types, name, ns, isAbstract, superTypes, (AttributeDescriptor)defaultGeometry);
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] types, String name, URI ns, boolean isAbstract) throws FactoryRegistryException, SchemaException {
        return FeatureTypes.newFeatureType(types, name, ns, isAbstract, null);
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] types, String name, URI ns) throws FactoryRegistryException, SchemaException {
        return FeatureTypes.newFeatureType(types, name, ns, false);
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] types, String name) throws FactoryRegistryException, SchemaException {
        return FeatureTypes.newFeatureType(types, name, DEFAULT_NAMESPACE, false);
    }

    public static List<FeatureType> getAncestors(FeatureType featureType) {
        ArrayList<FeatureType> ancestors = new ArrayList<FeatureType>();
        while (featureType.getSuper() instanceof FeatureType) {
            FeatureType superType = (FeatureType)featureType.getSuper();
            ancestors.add(superType);
            featureType = superType;
        }
        return ancestors;
    }

    public static boolean isDecendedFrom(FeatureType featureType, URI namespace, String typeName) {
        if (featureType == null) {
            return false;
        }
        List<FeatureType> ancestors = FeatureTypes.getAncestors(featureType);
        for (FeatureType superType : ancestors) {
            if (!(namespace == null ? Utilities.equals(superType.getName().getLocalPart(), typeName) : Utilities.equals(superType.getName().getNamespaceURI(), namespace.toString()) && Utilities.equals(superType.getName().getLocalPart(), typeName))) continue;
            return true;
        }
        return false;
    }

    public static boolean isDecendedFrom(FeatureType featureType, FeatureType isParentType) {
        try {
            return FeatureTypes.isDecendedFrom(featureType, new URI(isParentType.getName().getNamespaceURI()), isParentType.getName().getLocalPart());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean equals(SimpleFeatureType typeA, SimpleFeatureType typeB) {
        return FeatureTypes.equals(typeA, typeB, false);
    }

    public static boolean equalsExact(SimpleFeatureType typeA, SimpleFeatureType typeB) {
        return FeatureTypes.equals(typeA, typeB, true);
    }

    static boolean equals(SimpleFeatureType typeA, SimpleFeatureType typeB, boolean compareUserMaps) {
        if (typeA == typeB) {
            return true;
        }
        if (typeA == null || typeB == null) {
            return false;
        }
        if (compareUserMaps && !FeatureTypes.equals(typeA.getUserData(), typeB.getUserData())) {
            return false;
        }
        return FeatureTypes.equalsId(typeA, typeB) && FeatureTypes.equals(typeA.getAttributeDescriptors(), typeB.getAttributeDescriptors(), compareUserMaps) && FeatureTypes.equalsAncestors(typeA, typeB);
    }

    static boolean equals(List attributesA, List attributesB, boolean compareUserMaps) {
        return FeatureTypes.equals(attributesA.toArray(new AttributeDescriptor[attributesA.size()]), attributesB.toArray(new AttributeDescriptor[attributesB.size()]), compareUserMaps);
    }

    public static boolean equals(List attributesA, List attributesB) {
        return FeatureTypes.equals(attributesA, attributesB, false);
    }

    public static boolean equalsExact(List attributesA, List attributesB) {
        return FeatureTypes.equals(attributesA, attributesB, true);
    }

    public static boolean equals(AttributeDescriptor[] attributesA, AttributeDescriptor[] attributesB) {
        return FeatureTypes.equals(attributesA, attributesB, false);
    }

    public static boolean equalsExact(AttributeDescriptor[] attributesA, AttributeDescriptor[] attributesB) {
        return FeatureTypes.equals(attributesA, attributesB, true);
    }

    static boolean equals(AttributeDescriptor[] attributesA, AttributeDescriptor[] attributesB, boolean compareUserMaps) {
        if (attributesA.length != attributesB.length) {
            return false;
        }
        int length = attributesA.length;
        for (int i = 0; i < length; ++i) {
            if (FeatureTypes.equals(attributesA[i], attributesB[i], compareUserMaps)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsAncestors(SimpleFeatureType typeA, SimpleFeatureType typeB) {
        return ((Object)FeatureTypes.ancestors(typeA)).equals(FeatureTypes.ancestors(typeB));
    }

    public static Set ancestors(SimpleFeatureType featureType) {
        if (featureType == null || FeatureTypes.getAncestors(featureType).isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return new HashSet<FeatureType>(FeatureTypes.getAncestors(featureType));
    }

    public static boolean equals(AttributeDescriptor a, AttributeDescriptor b) {
        return FeatureTypes.equals(a, b, false);
    }

    public static boolean equalsExact(AttributeDescriptor a, AttributeDescriptor b) {
        return FeatureTypes.equals(a, b, true);
    }

    static boolean equals(AttributeDescriptor a, AttributeDescriptor b, boolean compareUserMaps) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return true;
        }
        if (!a.equals(b)) {
            return false;
        }
        if (compareUserMaps) {
            if (!FeatureTypes.equals(a.getUserData(), b.getUserData())) {
                return false;
            }
            if (!FeatureTypes.equals(a.getType().getUserData(), b.getType().getUserData())) {
                return false;
            }
        }
        return true;
    }

    static boolean equals(Map a, Map b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a != null && a.size() == 0 && b == null) {
            return true;
        }
        if (b != null && b.size() == 0 && a == null) {
            return true;
        }
        return ((Object)a).equals(b);
    }

    public static boolean equalsId(SimpleFeatureType typeA, SimpleFeatureType typeB) {
        if (typeA == typeB) {
            return true;
        }
        if (typeA == null || typeB == null) {
            return false;
        }
        String typeNameA = typeA.getTypeName();
        String typeNameB = typeB.getTypeName();
        if (typeNameA == null && typeNameB != null) {
            return false;
        }
        if (!typeNameA.equals(typeNameB)) {
            return false;
        }
        String namespaceA = typeA.getName().getNamespaceURI();
        String namespaceB = typeB.getName().getNamespaceURI();
        if (namespaceA == null && namespaceB == null) {
            return true;
        }
        if (namespaceA == null && namespaceB != null) {
            return false;
        }
        return namespaceA.equals(namespaceB);
    }

    static {
        URI uri;
        try {
            uri = new URI("http://www.opengis.net/gml");
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        DEFAULT_NAMESPACE = uri;
        SimpleFeatureType featureType = null;
        try {
            featureType = FeatureTypes.newFeatureType(null, "Feature", new URI("http://www.opengis.net/gml"), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ABSTRACT_FEATURE_TYPE = featureType;
        DEFAULT_TYPENAME = new NameImpl("AbstractFeatureCollectionType", DEFAULT_NAMESPACE.toString());
        EMPTY = new SimpleFeatureTypeImpl((Name)new NameImpl("Empty"), Collections.EMPTY_LIST, null, false, (List<Filter>)Collections.EMPTY_LIST, null, null);
    }
}

