/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockException;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContentFeatureStore
extends ContentFeatureSource
implements SimpleFeatureStore,
FeatureLocking<SimpleFeatureType, SimpleFeature> {
    protected final int WRITER_ADD = 1;
    protected final int WRITER_UPDATE = 2;
    protected FeatureLock lock = FeatureLock.TRANSACTION;

    public ContentFeatureStore(ContentEntry entry, Query query) {
        super(entry, query);
    }

    public final FeatureWriter<SimpleFeatureType, SimpleFeature> getWriter(Filter filter) throws IOException {
        return this.getWriter(filter, 3);
    }

    public final FeatureWriter<SimpleFeatureType, SimpleFeature> getWriter(Filter filter, int flags) throws IOException {
        return this.getWriter(new DefaultQuery(this.getSchema().getTypeName(), filter), flags);
    }

    public final FeatureWriter<SimpleFeatureType, SimpleFeature> getWriter(Query query) throws IOException {
        return this.getWriter(query, 3);
    }

    public final FeatureWriter<SimpleFeatureType, SimpleFeature> getWriter(Query query, int flags) throws IOException {
        query = this.joinQuery(query);
        query = this.resolvePropertyNames(query);
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getWriterInternal(query, flags);
        LockingManager lockingManager = this.getDataStore().getLockingManager();
        return ((InProcessLockingManager)lockingManager).checkedWriter(writer, this.transaction);
    }

    protected abstract FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(Query var1, int var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<FeatureId> addFeatures(Collection collection) throws IOException {
        LinkedList<FeatureId> ids = new LinkedList<FeatureId>();
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getWriter(Filter.INCLUDE, 1);
        try {
            Iterator f = collection.iterator();
            while (f.hasNext()) {
                FeatureId id = this.addFeature((SimpleFeature)f.next(), writer);
                ids.add(id);
            }
        }
        finally {
            writer.close();
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) throws IOException {
        LinkedList<FeatureId> ids = new LinkedList<FeatureId>();
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getWriter(Filter.INCLUDE, 1);
        Iterator<SimpleFeature> f = collection.iterator();
        try {
            while (f.hasNext()) {
                FeatureId id = this.addFeature(f.next(), writer);
                ids.add(id);
            }
        }
        finally {
            writer.close();
            collection.close(f);
        }
        return ids;
    }

    FeatureId addFeature(SimpleFeature feature, FeatureWriter<SimpleFeatureType, SimpleFeature> writer) throws IOException {
        SimpleFeature toWrite = writer.next();
        for (int i = 0; i < toWrite.getType().getAttributeCount(); ++i) {
            String name = toWrite.getType().getDescriptor(i).getLocalName();
            toWrite.setAttribute(name, feature.getAttribute(name));
        }
        if (feature.getUserData().size() > 0) {
            toWrite.getUserData().putAll(feature.getUserData());
        }
        boolean useExisting = Boolean.TRUE.equals(feature.getUserData().get(Hints.USE_PROVIDED_FID));
        if (this.getQueryCapabilities().isUseProvidedFIDSupported() && useExisting) {
            ((FeatureIdImpl)toWrite.getIdentifier()).setID(feature.getID());
        }
        writer.write();
        feature.getUserData().putAll(toWrite.getUserData());
        FeatureId id = toWrite.getIdentifier();
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        this.removeFeatures(Filter.INCLUDE);
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getWriter(Filter.INCLUDE, 1);
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = reader.next();
                SimpleFeature toWrite = writer.next();
                for (int i = 0; i < toWrite.getType().getAttributeCount(); ++i) {
                    String name = toWrite.getType().getDescriptor(i).getLocalName();
                    toWrite.setAttribute(name, feature.getAttribute(name));
                }
                writer.write();
            }
        }
        finally {
            writer.close();
        }
    }

    @Override
    public void modifyFeatures(AttributeDescriptor[] type, Object[] value, Filter filter) throws IOException {
        Name[] attributeNames = new Name[type.length];
        for (int i = 0; i < type.length; ++i) {
            attributeNames[i] = type[i].getName();
        }
        this.modifyFeatures(attributeNames, value, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyFeatures(Name[] type, Object[] value, Filter filter) throws IOException {
        if (filter == null) {
            String msg = "Must specify a filter, must not be null.";
            throw new IllegalArgumentException(msg);
        }
        filter = this.resolvePropertyNames(filter);
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getWriter(filter, 2);
        try {
            while (writer.hasNext()) {
                SimpleFeature toWrite = writer.next();
                for (int i = 0; i < type.length; ++i) {
                    toWrite.setAttribute(type[i], value[i]);
                }
                writer.write();
            }
        }
        finally {
            writer.close();
        }
    }

    @Override
    public final void modifyFeatures(String name, Object attributeValue, Filter filter) throws IOException {
        this.modifyFeatures(new Name[]{new NameImpl(name)}, new Object[]{attributeValue}, filter);
    }

    @Override
    public final void modifyFeatures(String[] names, Object[] values, Filter filter) throws IOException {
        Name[] attributeNames = new Name[names.length];
        for (int i = 0; i < names.length; ++i) {
            attributeNames[i] = new NameImpl(names[i]);
        }
        this.modifyFeatures(attributeNames, values, filter);
    }

    @Override
    public final void modifyFeatures(AttributeDescriptor type, Object value, Filter filter) throws IOException {
        this.modifyFeatures(new Name[]{type.getName()}, new Object[]{value}, filter);
    }

    @Override
    public final void modifyFeatures(Name name, Object value, Filter filter) throws IOException {
        this.modifyFeatures(new Name[]{name}, new Object[]{value}, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFeatures(Filter filter) throws IOException {
        if (filter == null) {
            String msg = "Must specify a filter, must not be null.";
            throw new IllegalArgumentException(msg);
        }
        filter = this.resolvePropertyNames(filter);
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getWriter(filter, 2);
        try {
            while (writer.hasNext()) {
                writer.next();
                writer.remove();
                writer.write();
            }
        }
        finally {
            writer.close();
        }
    }

    @Override
    public final void setFeatureLock(FeatureLock lock) {
        this.lock = lock;
    }

    @Override
    public final int lockFeatures() throws IOException {
        return this.lockFeatures(Filter.INCLUDE);
    }

    @Override
    public final int lockFeatures(Query query) throws IOException {
        return this.lockFeatures(query.getFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int lockFeatures(Filter filter) throws IOException {
        Logger logger = this.getDataStore().getLogger();
        String typeName = this.getSchema().getTypeName();
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.getReader(filter);
        try {
            int locked = 0;
            while (reader.hasNext()) {
                SimpleFeature feature = reader.next();
                try {
                    this.getDataStore().getLockingManager().lockFeatureID(typeName, feature.getID(), this.transaction, this.lock);
                    logger.fine("Locked feature: " + feature.getID());
                    ++locked;
                }
                catch (FeatureLockException e) {
                    String msg = "Unable to lock feature:" + feature.getID() + "." + " Change logging to FINEST for stack trace";
                    logger.fine(msg);
                    logger.log(Level.FINEST, "Unable to lock feature: " + feature.getID(), e);
                }
            }
            int n = locked;
            return n;
        }
        finally {
            reader.close();
        }
    }

    @Override
    public final void unLockFeatures() throws IOException {
        this.unLockFeatures(Filter.INCLUDE);
    }

    @Override
    public final void unLockFeatures(Query query) throws IOException {
        this.unLockFeatures(query.getFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unLockFeatures(Filter filter) throws IOException {
        filter = this.resolvePropertyNames(filter);
        String typeName = this.getSchema().getTypeName();
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.getReader(filter);
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = reader.next();
                this.getDataStore().getLockingManager().unLockFeatureID(typeName, feature.getID(), this.transaction, this.lock);
            }
        }
        finally {
            reader.close();
        }
    }
}

