/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.util.Collections;
import java.util.Map;
import org.geotools.util.SimpleInternationalString;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameter<T> {
    public final String key;
    public final InternationalString title;
    public final InternationalString description;
    public final Class<T> type;
    public final boolean required;
    public final int minOccurs;
    public final int maxOccurs;
    public final Object sample;
    public static final String FEATURE_TYPE = "featureType";
    public static final String IS_PASSWORD = "isPassword";
    public static final String LENGTH = "length";
    public static final String CRS = "crs";
    public static final String ELEMENT = "element";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String EXT = "ext";
    public static final String LEVEL = "level";
    public final Map<String, Object> metadata;

    public Parameter(String key, Class<T> type, String title, String description) {
        this(key, type, new SimpleInternationalString(title), new SimpleInternationalString(description));
    }

    public Parameter(String key, Class<T> type, String title, String description, Map<String, Object> metadata) {
        this(key, type, new SimpleInternationalString(title), new SimpleInternationalString(description), metadata);
    }

    public Parameter(String key, Class<T> type, InternationalString title, InternationalString description) {
        this(key, type, title, description, true, 1, 1, null, null);
    }

    public Parameter(String key, Class<T> type, InternationalString title, InternationalString description, Map<String, Object> metadata) {
        this(key, type, title, description, true, 1, 1, null, metadata);
    }

    public Parameter(String key, Class<T> type, InternationalString title, InternationalString description, boolean required, int min, int max, Object sample, Map<String, Object> metadata) {
        this.key = key;
        this.title = title;
        this.type = type;
        this.description = description;
        this.required = required;
        this.minOccurs = min;
        this.maxOccurs = max;
        this.sample = sample;
        this.metadata = metadata == null ? null : Collections.unmodifiableMap(metadata);
    }

    public boolean isPassword() {
        return this.metadata != null && Boolean.TRUE.equals(this.metadata.get(IS_PASSWORD));
    }

    public String getLevel() {
        if (this.metadata == null) {
            return "user";
        }
        String level = (String)this.metadata.get(LEVEL);
        if (level == null) {
            return "user";
        }
        return level;
    }
}

