/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.fop.image.loader.batik.BatikImageFlavors;
import org.apache.fop.image.loader.batik.BatikUtil;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.ps.PSBridgeContext;
import org.apache.fop.render.ps.PSImageUtils;
import org.apache.fop.render.ps.PSRenderingContext;
import org.apache.fop.render.ps.svg.PSSVGGraphics2D;
import org.apache.fop.svg.SVGEventProducer;
import org.apache.fop.svg.SVGUserAgent;
import org.apache.fop.svg.font.FOPFontFamilyResolverImpl;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.ps.ImageEncoder;
import org.apache.xmlgraphics.ps.ImageEncodingHelper;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PSImageHandlerSVG
implements ImageHandler {
    private static final Color FALLBACK_COLOR = new Color(255, 33, 117);
    private HashMap<String, String> gradientsFound = new HashMap();
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{BatikImageFlavors.SVG_DOM};

    @Override
    public void handleImage(RenderingContext context, Image image, Rectangle pos) throws IOException {
        PSRenderingContext psContext = (PSRenderingContext)context;
        PSGenerator gen = psContext.getGenerator();
        ImageXMLDOM imageSVG = (ImageXMLDOM)image;
        if (this.shouldRaster(imageSVG)) {
            InputStream is = this.renderSVGToInputStream(context, imageSVG);
            float x = (float)pos.getX() / 1000.0f;
            float y = (float)pos.getY() / 1000.0f;
            float w = (float)pos.getWidth() / 1000.0f;
            float h = (float)pos.getHeight() / 1000.0f;
            Rectangle2D.Double targetRect = new Rectangle2D.Double(x, y, w, h);
            MaskedImage mi = this.convertToRGB(ImageIO.read(is));
            BufferedImage ri = mi.getImage();
            ImageEncoder encoder = ImageEncodingHelper.createRenderedImageEncoder(ri);
            Dimension imgDim = new Dimension(ri.getWidth(), ri.getHeight());
            String imgDescription = ri.getClass().getName();
            ImageEncodingHelper helper = new ImageEncodingHelper(ri);
            ColorModel cm = helper.getEncodedColorModel();
            PSImageUtils.writeImage(encoder, imgDim, imgDescription, (Rectangle2D)targetRect, cm, gen, ri, mi.getMaskColor());
        } else {
            GraphicsNode root;
            boolean strokeText = PSImageHandlerSVG.shouldStrokeText(imageSVG.getDocument().getChildNodes());
            SVGUserAgent ua = new SVGUserAgent(context.getUserAgent(), new FOPFontFamilyResolverImpl(psContext.getFontInfo()), new AffineTransform());
            PSSVGGraphics2D graphics = new PSSVGGraphics2D(strokeText, gen);
            graphics.setGraphicContext(new GraphicContext());
            PSBridgeContext ctx = new PSBridgeContext(ua, strokeText ? null : psContext.getFontInfo(), context.getUserAgent().getImageManager(), context.getUserAgent().getImageSessionContext());
            Document clonedDoc = BatikUtil.cloneSVGDocument(imageSVG.getDocument());
            try {
                GVTBuilder builder = new GVTBuilder();
                root = builder.build((BridgeContext)ctx, clonedDoc);
            }
            catch (Exception e) {
                SVGEventProducer eventProducer = SVGEventProducer.Provider.get(context.getUserAgent().getEventBroadcaster());
                eventProducer.svgNotBuilt(this, e, image.getInfo().getOriginalURI());
                return;
            }
            float w = (float)ctx.getDocumentSize().getWidth() * 1000.0f;
            float h = (float)ctx.getDocumentSize().getHeight() * 1000.0f;
            float sx = (float)pos.width / w;
            float sy = (float)pos.height / h;
            gen.commentln("%FOPBeginSVG");
            gen.saveGraphicsState();
            boolean clip = false;
            gen.concatMatrix(sx, 0.0, 0.0, sy, pos.getMinX() / 1000.0, pos.getMinY() / 1000.0);
            AffineTransform transform = new AffineTransform();
            transform.translate(pos.getMinX(), pos.getMinY());
            gen.getCurrentState().concatMatrix(transform);
            try {
                root.paint(graphics);
            }
            catch (Exception e) {
                SVGEventProducer eventProducer = SVGEventProducer.Provider.get(context.getUserAgent().getEventBroadcaster());
                eventProducer.svgRenderingError(this, e, image.getInfo().getOriginalURI());
            }
            gen.restoreGraphicsState();
            gen.commentln("%FOPEndSVG");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream renderSVGToInputStream(RenderingContext context, ImageXMLDOM imageSVG) throws IOException {
        PNGTranscoder png = new PNGTranscoder();
        Float width = Float.valueOf(this.getDimension(imageSVG.getDocument(), "width").floatValue() * 8.0f);
        png.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, width);
        Float height = Float.valueOf(this.getDimension(imageSVG.getDocument(), "height").floatValue() * 8.0f);
        png.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, height);
        TranscoderInput input = new TranscoderInput(imageSVG.getDocument());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TranscoderOutput output = new TranscoderOutput(os);
        try {
            png.transcode(input, output);
        }
        catch (TranscoderException ex) {
            SVGEventProducer eventProducer = SVGEventProducer.Provider.get(context.getUserAgent().getEventBroadcaster());
            eventProducer.svgRenderingError(this, ex, imageSVG.getInfo().getOriginalURI());
        }
        finally {
            os.flush();
            os.close();
        }
        return new ByteArrayInputStream(os.toByteArray());
    }

    private MaskedImage convertToRGB(BufferedImage alphaImage) {
        int[] red = new int[256];
        int[] green = new int[256];
        int[] blue = new int[256];
        BufferedImage rgbImage = new BufferedImage(alphaImage.getWidth(), alphaImage.getHeight(), 1);
        for (int cx = 0; cx < alphaImage.getWidth(); ++cx) {
            for (int cy = 0; cy < alphaImage.getHeight(); ++cy) {
                int pixelValue = alphaImage.getRGB(cx, cy);
                Color pixelColor = new Color(pixelValue);
                int n = pixelColor.getRed();
                red[n] = red[n] + 1;
                int n2 = pixelColor.getGreen();
                green[n2] = green[n2] + 1;
                int n3 = pixelColor.getBlue();
                blue[n3] = blue[n3] + 1;
            }
        }
        Color alphaSwap = null;
        for (int i = 0; i < 256; ++i) {
            if (red[i] == 0) {
                alphaSwap = new Color(i, 0, 0);
                break;
            }
            if (green[i] == 0) {
                alphaSwap = new Color(0, i, 0);
                break;
            }
            if (blue[i] != 0) continue;
            alphaSwap = new Color(0, 0, i);
            break;
        }
        if (alphaSwap == null) {
            alphaSwap = FALLBACK_COLOR;
        }
        for (int cx = 0; cx < alphaImage.getWidth(); ++cx) {
            for (int cy = 0; cy < alphaImage.getHeight(); ++cy) {
                int pixelValue = alphaImage.getRGB(cx, cy);
                if (pixelValue == 0) {
                    rgbImage.setRGB(cx, cy, alphaSwap.getRGB());
                    continue;
                }
                rgbImage.setRGB(cx, cy, alphaImage.getRGB(cx, cy));
            }
        }
        return new MaskedImage(rgbImage, alphaSwap);
    }

    private Float getDimension(Document document, String dimension) {
        if (document.getFirstChild().getAttributes().getNamedItem(dimension) != null) {
            String width = document.getFirstChild().getAttributes().getNamedItem(dimension).getNodeValue();
            width = width.replaceAll("[^\\d.]", "");
            return Float.valueOf(Float.parseFloat(width));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldRaster(ImageXMLDOM image) {
        try {
            ArrayList<String> gradMatches = new ArrayList<String>();
            gradMatches.add("radialGradient");
            gradMatches.add("linearGradient");
            boolean bl = this.recurseSVGElements(image.getDocument().getChildNodes(), gradMatches, false);
            return bl;
        }
        finally {
            this.gradientsFound.clear();
        }
    }

    private boolean recurseSVGElements(NodeList childNodes, List<String> gradMatches, boolean isMatched) {
        boolean opacityFound = false;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node curNode = childNodes.item(i);
            if (isMatched && curNode.getLocalName() != null && curNode.getLocalName().equals("stop")) {
                String opacityValue;
                if (curNode.getAttributes().getNamedItem("style") != null) {
                    String[] stylePairs;
                    for (String stylePair : stylePairs = curNode.getAttributes().getNamedItem("style").getNodeValue().split(";")) {
                        String[] style = stylePair.split(":");
                        if (!style[0].equalsIgnoreCase("stop-opacity") || !(Double.parseDouble(style[1]) < 1.0)) continue;
                        return true;
                    }
                }
                if (curNode.getAttributes().getNamedItem("stop-opacity") != null && Double.parseDouble(opacityValue = curNode.getAttributes().getNamedItem("stop-opacity").getNodeValue()) < 1.0) {
                    return true;
                }
            }
            String nodeName = curNode.getLocalName();
            boolean inMatch = false;
            if (!isMatched) {
                boolean bl = inMatch = nodeName != null && gradMatches.contains(nodeName);
                if (inMatch) {
                    this.gradientsFound.put(curNode.getAttributes().getNamedItem("id").getNodeValue(), nodeName);
                }
            } else {
                inMatch = true;
            }
            if (!(opacityFound = this.recurseSVGElements(curNode.getChildNodes(), gradMatches, inMatch))) continue;
            return true;
        }
        return opacityFound;
    }

    public static boolean shouldStrokeText(NodeList childNodes) {
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node curNode = childNodes.item(i);
            if (PSImageHandlerSVG.shouldStrokeText(curNode.getChildNodes())) {
                return true;
            }
            if (!"text".equals(curNode.getLocalName())) continue;
            return curNode.getAttributes().getNamedItem("filter") != null;
        }
        return false;
    }

    @Override
    public int getPriority() {
        return 400;
    }

    @Override
    public Class getSupportedImageClass() {
        return ImageXMLDOM.class;
    }

    @Override
    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    @Override
    public boolean isCompatible(RenderingContext targetContext, Image image) {
        if (targetContext instanceof PSRenderingContext) {
            PSRenderingContext psContext = (PSRenderingContext)targetContext;
            return !psContext.isCreateForms() && (image == null || image instanceof ImageXMLDOM && image.getFlavor().isCompatible(BatikImageFlavors.SVG_DOM));
        }
        return false;
    }

    private static class MaskedImage {
        private Color maskColor = new Color(0, 0, 0);
        private BufferedImage image;

        public MaskedImage(BufferedImage image, Color maskColor) {
            this.image = image;
            this.maskColor = maskColor;
        }

        public Color getMaskColor() {
            return this.maskColor;
        }

        public BufferedImage getImage() {
            return this.image;
        }
    }
}

