/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.util.identifier;

import java.io.Serializable;
import org.apache.commons.lang.functor.Factory;
import org.apache.commons.util.identifier.IdentifierFactoryException;

public class StringIncrementingVLongIdentifierFactory
implements Factory,
Serializable {
    public static final Factory INSTANCE = new StringIncrementingVLongIdentifierFactory();
    private final boolean iWrap;
    private final int iPadSize;
    private long iCount1 = 0L;
    private long iCount2 = 0L;

    public static String nextIdentifier() {
        return (String)INSTANCE.create();
    }

    public StringIncrementingVLongIdentifierFactory() {
        this(false, -1);
    }

    public StringIncrementingVLongIdentifierFactory(boolean wrap) {
        this(wrap, -1);
    }

    public StringIncrementingVLongIdentifierFactory(boolean wrap, int padLength) {
        this.iWrap = wrap;
        this.iPadSize = padLength > 0 ? padLength : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object create() {
        long value1 = 0L;
        long value2 = 0L;
        StringIncrementingVLongIdentifierFactory stringIncrementingVLongIdentifierFactory = this;
        synchronized (stringIncrementingVLongIdentifierFactory) {
            if (this.iCount1 == Long.MAX_VALUE) {
                if (this.iCount2 == Long.MAX_VALUE) {
                    if (!this.iWrap) throw new IdentifierFactoryException("The maximum number of identifiers has been reached");
                    this.iCount2 = 0L;
                } else {
                    ++this.iCount2;
                }
                this.iCount1 = 0L;
            }
            value1 = this.iCount1++;
            value2 = this.iCount2;
        }
        StringBuffer buf = new StringBuffer(50);
        buf.append(Long.toString(value2));
        buf.append(Long.toString(value1));
        if (this.iPadSize <= 0) return buf.toString();
        try {
            char[] array = new char[this.iPadSize - buf.length()];
            int i = 0;
            while (i < array.length) {
                array[i] = 48;
                ++i;
            }
            buf.insert(0, array);
            return buf.toString();
        }
        catch (NegativeArraySizeException ex) {
            throw new IdentifierFactoryException("The padding size for the identifier has been exceeded");
        }
    }
}

