/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.util.identifier;

import java.io.Serializable;
import org.apache.commons.lang.functor.Factory;
import org.apache.commons.util.identifier.IdentifierFactoryException;

public class StringIncrementingLongIdentifierFactory
implements Factory,
Serializable {
    public static final Factory INSTANCE = new StringIncrementingLongIdentifierFactory();
    private final boolean iWrap;
    private final long iPadScale;
    private long iCount = 0L;

    public static String nextIdentifier() {
        return (String)INSTANCE.create();
    }

    public StringIncrementingLongIdentifierFactory() {
        this(false, 0L, -1);
    }

    public StringIncrementingLongIdentifierFactory(boolean wrap) {
        this(wrap, 0L, -1);
    }

    public StringIncrementingLongIdentifierFactory(boolean wrap, long initialValue) {
        this(wrap, initialValue, -1);
    }

    public StringIncrementingLongIdentifierFactory(boolean wrap, long initialValue, int padLength) {
        this.iWrap = wrap;
        this.iCount = initialValue;
        this.iPadScale = padLength > 0 ? (long)Math.pow(10.0, padLength) : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create() {
        long value = 0L;
        if (this.iWrap) {
            StringIncrementingLongIdentifierFactory stringIncrementingLongIdentifierFactory = this;
            synchronized (stringIncrementingLongIdentifierFactory) {
                value = this.iCount++;
            }
        }
        StringIncrementingLongIdentifierFactory stringIncrementingLongIdentifierFactory = this;
        synchronized (stringIncrementingLongIdentifierFactory) {
            if (this.iCount == Long.MAX_VALUE) {
                throw new IdentifierFactoryException("The maximum number of identifiers has been reached");
            }
            value = this.iCount++;
        }
        if (this.iPadScale > 0L) {
            return Long.toString(value += this.iPadScale).substring(1);
        }
        return Long.toString(value);
    }
}

