/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.util.identifier;

import java.io.Serializable;
import java.util.Random;
import org.apache.commons.lang.functor.Factory;

public class LongRandomIdentifierFactory
implements Factory,
Serializable {
    public static final Factory INSTANCE = new LongRandomIdentifierFactory();
    private final boolean iPositiveOnly;
    private Random iRandom = new Random();

    public static Long nextIdentifier() {
        return (Long)INSTANCE.create();
    }

    public LongRandomIdentifierFactory() {
        this(true);
    }

    public LongRandomIdentifierFactory(boolean positiveOnly) {
        this.iPositiveOnly = positiveOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create() {
        long value = 0L;
        if (this.iPositiveOnly) {
            LongRandomIdentifierFactory longRandomIdentifierFactory = this;
            synchronized (longRandomIdentifierFactory) {
                while ((value = this.iRandom.nextLong()) < 0L) {
                }
            }
        }
        LongRandomIdentifierFactory longRandomIdentifierFactory = this;
        synchronized (longRandomIdentifierFactory) {
            value = this.iRandom.nextLong();
        }
        return new Long(value);
    }
}

