/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.util.identifier;

import java.io.Serializable;
import org.apache.commons.lang.functor.Factory;
import org.apache.commons.util.identifier.IdentifierFactoryException;

public class LongIncrementingIdentifierFactory
implements Factory,
Serializable {
    public static final Factory INSTANCE = new LongIncrementingIdentifierFactory();
    private final boolean iWrap;
    private long iCount = 0L;

    public static Long nextIdentifier() {
        return (Long)INSTANCE.create();
    }

    public LongIncrementingIdentifierFactory() {
        this(false, 0L);
    }

    public LongIncrementingIdentifierFactory(boolean wrap) {
        this(wrap, 0L);
    }

    public LongIncrementingIdentifierFactory(boolean wrap, long initialValue) {
        this.iWrap = wrap;
        this.iCount = initialValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create() {
        long value = 0L;
        if (this.iWrap) {
            LongIncrementingIdentifierFactory longIncrementingIdentifierFactory = this;
            synchronized (longIncrementingIdentifierFactory) {
                value = this.iCount++;
            }
        }
        LongIncrementingIdentifierFactory longIncrementingIdentifierFactory = this;
        synchronized (longIncrementingIdentifierFactory) {
            if (this.iCount == Long.MAX_VALUE) {
                throw new IdentifierFactoryException("The maximum number of identifiers has been reached");
            }
            value = this.iCount++;
        }
        return new Long(value);
    }
}

