/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.util;

public class StopWatch {
    private long startTime = -1L;
    private long stopTime = -1L;

    public static void main(String[] strs) {
        StopWatch obj = new StopWatch();
        obj.start();
        try {
            Thread.currentThread();
            Thread.sleep(1500L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        obj.stop();
        System.out.println(obj);
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public void stop() {
        this.stopTime = System.currentTimeMillis();
    }

    public void reset() {
        this.startTime = -1L;
        this.stopTime = -1L;
    }

    public void split() {
        this.stopTime = System.currentTimeMillis();
    }

    public void unsplit() {
        this.stopTime = -1L;
    }

    public long getTime() {
        if (this.stopTime == -1L) {
            return System.currentTimeMillis() - this.startTime;
        }
        return this.stopTime - this.startTime;
    }

    public String toString() {
        return StopWatch.getTimeString(this.getTime());
    }

    public static String getTimeString(long time) {
        int HIM = 3600000;
        int MIM = 60000;
        int hours = (int)(time / (long)HIM);
        int minutes = (int)((time -= (long)(hours * HIM)) / (long)MIM);
        int seconds = (int)((time -= (long)(minutes * MIM)) / 1000L);
        int milliseconds = (int)(time -= (long)(seconds * 1000));
        return hours + "h:" + minutes + "m:" + seconds + "s:" + milliseconds + "ms";
    }
}

