/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.web;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ktde.util.io.CsvWriter;
import org.springframework.web.servlet.view.AbstractView;

public class CsvView
extends AbstractView {
    public CsvView() {
        this.setContentType("text/plain");
    }

    @Override
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String contentType = this.getContentType();
        if (contentType == null || !contentType.equalsIgnoreCase("text/plain")) {
            throw new Exception("Content Type must be text/plain");
        }
        if (model.size() > 1) {
            throw new Exception("View allows only zero to one Collection");
        }
        if (!model.isEmpty()) {
            List collection = (List)model.values().iterator().next();
            this.writeCsv(response, collection);
        }
    }

    protected void writeCsv(HttpServletResponse response, List<List<String>> collection) throws IOException {
        CsvWriter csvWriter = new CsvWriter(response.getWriter());
        for (List<String> list : collection) {
            csvWriter.writeLine(list);
        }
        csvWriter.flush();
    }
}

