/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.visitor;

import de.datomino.util.visitor.ReflectionVisitor;
import de.datomino.util.visitor.ReflectionVisitorNodeDetector;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ReflectionVisitWalker {
    private Map<Class<?>, ReflectionVisitor<?>> visitorMap;
    private ReflectionVisitorNodeDetector reflectionVisitorNodeDetector;

    public ReflectionVisitWalker(ReflectionVisitorNodeDetector reflectionVisitorNodeDetector) {
        this.reflectionVisitorNodeDetector = reflectionVisitorNodeDetector;
        this.visitorMap = new HashMap();
    }

    public <U> void addVisitor(Class<U> clazz, ReflectionVisitor<U> reflectionVisitor) {
        this.visitorMap.put(clazz, reflectionVisitor);
    }

    public void walk(Object root) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        if (root != null) {
            ReflectionVisitor<?> reflectionVisitor = this.visitorMap.get(root.getClass());
            if (reflectionVisitor != null) {
                reflectionVisitor.begin(root);
            }
            BeanInfo beanInfo = Introspector.getBeanInfo(root.getClass());
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                Method getter;
                if (propertyDescriptor.getName().equals("class") || (getter = propertyDescriptor.getReadMethod()) == null) continue;
                Object value = getter.invoke(root, new Object[0]);
                Class<?> returnType = getter.getReturnType();
                if (Iterable.class.isAssignableFrom(returnType)) {
                    Iterable iterable = (Iterable)value;
                    for (Object element : iterable) {
                        this.walkDeeper(getter, element);
                    }
                    continue;
                }
                this.walkDeeper(getter, value);
            }
            if (reflectionVisitor != null) {
                reflectionVisitor.end(root);
            }
        }
    }

    private void walkDeeper(Method getter, Object element) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        if (this.reflectionVisitorNodeDetector.isNode(element, getter)) {
            this.walk(element);
        }
    }
}

