/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.time;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public final class TimeUtil {
    public static int getSecondsFromLastMidnight(Date date) {
        Date normalizedDate = TimeUtil.normalize(date);
        long millis = date.getTime() - normalizedDate.getTime();
        int s = millis % 1000L < 500L ? 0 : 1;
        return (int)(millis / 1000L) + s;
    }

    public static Date normalize(Date date) {
        return TimeUtil.setTime(date, 0, 0, 0);
    }

    public static void normalize(GregorianCalendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static Date setTime(Date date, int hours, int minutes, int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, hours);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date createDate(int year, int month, int day, int hours, int minutes, int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(11, hours);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static int mapCalendarMonthToXmlGregorianCalendarMonth(int month) {
        return month + 1;
    }

    public static boolean isSamedWeek(Date date1, Date date2) {
        return TimeUtil.isSamedWeek(TimeUtil.convertDateToCalendar(date1), TimeUtil.convertDateToCalendar(date2));
    }

    public static Calendar convertDateToCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static boolean isSamedWeek(Calendar cal1, Calendar cal2) {
        int weekOfYear2;
        int weekOfYear1 = cal1.get(3);
        return weekOfYear1 == (weekOfYear2 = cal2.get(3)) && cal1.get(1) == cal2.get(1);
    }

    public static int getDayOfWeek(Date date) {
        return TimeUtil.convertDateToCalendar(date).get(7);
    }

    public static boolean isSamedDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return TimeUtil.isSameDay(cal1, cal2);
    }

    public static Date convertToDate(XMLGregorianCalendar xmlGregorianCalendar) {
        return xmlGregorianCalendar.toGregorianCalendar().getTime();
    }

    public static String formatDate(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(date);
    }

    public static Date now() {
        return new Date();
    }

    public static Date getCurrentDay() {
        Calendar today = Calendar.getInstance();
        today.set(11, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        return today.getTime();
    }

    public static Date getFarFarFuture() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(TimeUtil.getEndOfDay(TimeUtil.getCurrentDay()));
        cal.set(5, 31);
        cal.set(2, 12);
        cal.set(1, 9999);
        return cal.getTime();
    }

    public static Date getStartOfDay(Date day) {
        Calendar calDay = Calendar.getInstance();
        calDay.setTime(day);
        calDay.set(11, 0);
        calDay.set(12, 0);
        calDay.set(13, 0);
        calDay.set(14, 0);
        return calDay.getTime();
    }

    public static Date getEndOfDay(Date day) {
        Calendar calDay = Calendar.getInstance();
        calDay.setTime(day);
        calDay.set(11, 23);
        calDay.set(12, 59);
        calDay.set(13, 59);
        calDay.set(14, 999);
        return calDay.getTime();
    }

    public static boolean isInInterval(Date timeOfArrival, Date startTime, Date endTime) {
        long timeOfArrivalMillis = timeOfArrival.getTime();
        return startTime.getTime() <= timeOfArrivalMillis && endTime.getTime() >= timeOfArrivalMillis;
    }

    public static String formatDuration(long timeInMillis, String day, String days, String hour, String hours, String minute, String minutes, String second, String seconds, String milli, String millis) {
        if (timeInMillis == 0L) {
            return "0 " + seconds;
        }
        long milliPart = timeInMillis % 1000L;
        long c = timeInMillis / 1000L;
        long secondPart = c % 60L;
        long minutePart = (c /= 60L) % 60L;
        long hourPart = (c /= 60L) % 24L;
        StringBuilder sb = new StringBuilder();
        boolean stringStarted = false;
        if ((c /= 24L) > 0L) {
            sb.append(c).append(" ").append(c == 1L ? day : days);
            stringStarted = true;
        }
        if (stringStarted || hourPart > 0L) {
            if (stringStarted) {
                sb.append(" ");
            }
            sb.append(hourPart).append(" ").append(c == 1L ? hour : hours);
            stringStarted = true;
        }
        if (stringStarted || minutePart > 0L) {
            if (stringStarted) {
                sb.append(" ");
            }
            sb.append(minutePart).append(" ").append(c == 1L ? minute : minutes);
            stringStarted = true;
        }
        if (stringStarted || secondPart > 0L) {
            if (stringStarted) {
                sb.append(" ");
            }
            sb.append(secondPart).append(" ").append(c == 1L ? second : seconds);
            stringStarted = true;
        }
        if (stringStarted || milliPart > 0L) {
            if (stringStarted) {
                sb.append(" ");
            }
            sb.append(milliPart).append(" ").append(c == 1L ? milli : millis);
            stringStarted = true;
        }
        return sb.toString();
    }

    public static String formatDuration(long timeInMillis) {
        return TimeUtil.formatDuration(timeInMillis, "Tag", "Tage", "Stunde", "Stunden", "Minute", "Minuten", "Sekunde", "Sekunden", "ms", "ms");
    }

    public static String formatDurationSeparated(long timeInMillis) {
        if (timeInMillis == 0L) {
            return "00:00:00";
        }
        long timeInMillisTemp = timeInMillis;
        long millis = timeInMillisTemp % 1000L;
        long seconds = (timeInMillisTemp /= 1000L) % 60L;
        long minutes = (timeInMillisTemp /= 60L) % 60L;
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.leftPad(Long.toString(timeInMillisTemp /= 60L), 2, '0')).append(":");
        sb.append(StringUtils.leftPad(Long.toString(minutes), 2, '0')).append(":").append(StringUtils.leftPad(Long.toString(seconds), 2, '0'));
        if (millis != 0L) {
            sb.append(".").append(StringUtils.leftPad(Long.toString(millis), 3, '0'));
        }
        return sb.toString();
    }

    public static String formatDurationToHourMinSec(long time) {
        long plainSeconds = time / 1000L;
        if (time % 1000L >= 500L) {
            ++plainSeconds;
        }
        long seconds = plainSeconds % 60L;
        long minutes = plainSeconds / 60L % 60L;
        long hours = plainSeconds / 60L / 60L;
        StringBuilder formatTime = new StringBuilder();
        if (hours == 0L) {
            formatTime.append("00");
        } else if (hours < 10L && hours > 0L) {
            formatTime.append("0").append(hours);
        } else {
            formatTime.append(hours);
        }
        if (minutes == 0L) {
            formatTime.append(":00");
        } else if (minutes < 10L && minutes > 0L) {
            formatTime.append(":0").append(minutes);
        } else {
            formatTime.append(":").append(minutes);
        }
        if (seconds == 0L) {
            formatTime.append(":00");
        } else if (seconds < 10L && seconds > 0L) {
            formatTime.append(":0").append(seconds);
        } else {
            formatTime.append(":").append(seconds);
        }
        return formatTime.toString();
    }

    public static GregorianCalendar convertToGregorianCalendar(Date rDate) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(rDate);
        return gc;
    }

    public static Date add(Date date, int field, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(field, amount);
        return cal.getTime();
    }

    public static int xmlMonthToCalendarMonth(int month) {
        switch (month) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 8;
            }
            case 10: {
                return 9;
            }
            case 11: {
                return 10;
            }
            case 12: {
                return 11;
            }
        }
        return month - 1;
    }

    public static Tupel<Date, Date> getDayTupel(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date startTime = calendar.getTime();
        calendar.add(5, 1);
        calendar.add(13, -1);
        Date endTime = calendar.getTime();
        return new Tupel<Date, Date>(startTime, endTime);
    }

    public static Tupel<Date, Date> getWeekTupel(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        int dayOfWeek = calendar.get(7);
        if (dayOfWeek == 1) {
            dayOfWeek = 8;
        }
        calendar.add(5, -1 * dayOfWeek + 2);
        Date startTime = calendar.getTime();
        calendar.add(5, 7);
        calendar.add(13, -1);
        Date endTime = calendar.getTime();
        return new Tupel<Date, Date>(startTime, endTime);
    }

    public static Tupel<Date, Date> getMonthTupel(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date startTime = calendar.getTime();
        calendar.add(2, 1);
        calendar.add(13, -1);
        Date endTime = calendar.getTime();
        return new Tupel<Date, Date>(startTime, endTime);
    }

    public static Collection<Date> getWeekDays(Date date) {
        LinkedList<Date> weekDays = new LinkedList<Date>();
        Date weekDay = TimeUtil.getWeekTupel(date).getElement1();
        for (int i = 0; i < 7; ++i) {
            weekDays.add(weekDay);
            weekDay = TimeUtil.add(weekDay, 5, 1);
        }
        return weekDays;
    }

    public static boolean isBetween(Date date, Date startTime, Date endTime) {
        if (date != null) {
            if (startTime == null && endTime == null) {
                return true;
            }
            if (startTime == null) {
                return date.before(endTime);
            }
            if (endTime == null) {
                return !startTime.after(date);
            }
            return !startTime.after(date) && date.before(endTime);
        }
        return false;
    }

    public static boolean covers(Tupel<Date, Date> timeWindow1, Tupel<Date, Date> timeWindow2) {
        long end2;
        long start1 = timeWindow1.getElement1() == null ? Long.MIN_VALUE : timeWindow1.getElement1().getTime();
        long end1 = timeWindow1.getElement2() == null ? Long.MAX_VALUE : timeWindow1.getElement2().getTime();
        long start2 = timeWindow2.getElement1() == null ? Long.MIN_VALUE : timeWindow2.getElement1().getTime();
        long l = end2 = timeWindow2.getElement2() == null ? Long.MAX_VALUE : timeWindow2.getElement2().getTime();
        return start1 <= end2 && end1 >= start2;
    }

    public static Tupel<Date, Date> findCover(Tupel<Date, Date> timeWindow1, Tupel<Date, Date> timeWindow2) {
        long end2;
        long start1 = timeWindow1.getElement1() == null ? Long.MIN_VALUE : timeWindow1.getElement1().getTime();
        long end1 = timeWindow1.getElement2() == null ? Long.MAX_VALUE : timeWindow1.getElement2().getTime();
        long start2 = timeWindow2.getElement1() == null ? Long.MIN_VALUE : timeWindow2.getElement1().getTime();
        long l = end2 = timeWindow2.getElement2() == null ? Long.MAX_VALUE : timeWindow2.getElement2().getTime();
        if (start1 <= end2 && end1 >= start2) {
            return new Tupel<Date, Date>(new Date(Math.max(start1, start2)), new Date(Math.min(end1, end2)));
        }
        return new Tupel<Object, Object>(null, null);
    }

    public static Date min(Date date1, Date date2) {
        if (date1.before(date2)) {
            return date1;
        }
        return date2;
    }

    public static Date max(Date date1, Date date2) {
        if (date1.after(date2)) {
            return date1;
        }
        return date2;
    }

    public static String getConstantNameForMonth(int month) {
        switch (month) {
            case 0: {
                return "JANUARY";
            }
            case 1: {
                return "FEBRUARY";
            }
            case 2: {
                return "MARCH";
            }
            case 3: {
                return "APRIL";
            }
            case 4: {
                return "MAY";
            }
            case 5: {
                return "JUNE";
            }
            case 6: {
                return "JULY";
            }
            case 7: {
                return "AUGUST";
            }
            case 8: {
                return "SEPTEMBER";
            }
            case 9: {
                return "OCTOBER";
            }
            case 10: {
                return "NOVEMBER";
            }
            case 11: {
                return "DECEMBER";
            }
        }
        return "";
    }

    public static int getDayCountForMonth(int year, int month) {
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 1: {
                if (year % 4 == 0 && year % 400 != 0) {
                    return 29;
                }
                return 28;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
        }
        return -1;
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2) && cal1.get(5) == cal2.get(5);
    }

    public static boolean isSameDay(Date d1, Date d2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(d1 == null ? new Date(Long.MIN_VALUE) : d1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(d2 == null ? new Date(Long.MIN_VALUE) : d2);
        return TimeUtil.isSameDay(cal1, cal2);
    }

    public static boolean isWeekday(Date date, int weekday) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7) == weekday;
    }

    public static Tripel<Integer, Integer, Integer> getTimeTripel(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return new Tripel<Integer, Integer, Integer>(cal.get(11), cal.get(12), cal.get(13));
    }

    public static int getRealMonthNumber(int month) {
        switch (month) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 9;
            }
            case 9: {
                return 10;
            }
            case 10: {
                return 11;
            }
            case 11: {
                return 12;
            }
        }
        return -1;
    }
}

