/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.swing.datetime;

import de.datomino.util.swing.SpringUtilities;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DateComponent
extends JPanel {
    private static final long serialVersionUID = -5194497562341500289L;
    private JSpinner day;
    private JSpinner month;
    private JSpinner year;

    public DateComponent() {
        super(new SpringLayout());
        this.buildLayout();
    }

    private void buildLayout() {
        Date now = new Date();
        this.day = new JSpinner(new SpinnerDateModel(now, null, null, 5));
        this.add(this.day);
        this.month = new JSpinner(new SpinnerDateModel(now, null, null, 2));
        this.add(this.month);
        this.year = new JSpinner(new SpinnerDateModel(now, null, null, 1));
        this.add(this.year);
        SpringUtilities.makeCompactGrid(this, 1, 3, 5, 5, 2, 2);
        this.day.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Date date = (Date)DateComponent.this.day.getValue();
                DateComponent.this.month.setValue(date);
                DateComponent.this.year.setValue(date);
            }
        });
        this.month.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Date date = (Date)DateComponent.this.month.getValue();
                DateComponent.this.day.setValue(date);
                DateComponent.this.year.setValue(date);
            }
        });
        this.day.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Date date = (Date)DateComponent.this.year.getValue();
                DateComponent.this.month.setValue(date);
                DateComponent.this.day.setValue(date);
            }
        });
    }

    public Date getData() {
        return (Date)this.day.getValue();
    }

    public void setDate(Date date) {
        this.day.setValue(date);
        this.month.setValue(date);
        this.year.setValue(date);
    }
}

