/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.swing.csv;

import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class CsvHeaderChooserPane
extends JPanel {
    private static final long serialVersionUID = -8319687792825539979L;
    private List<String> header;
    private List<CsvField> toSelect;
    private Map<CsvField, JComboBox> headerBoxes;

    public CsvHeaderChooserPane(Collection<CsvField> fields, List<String> header, int columns) {
        this.toSelect = new ArrayList<CsvField>(fields);
        this.header = header;
        this.buildLayout(columns);
    }

    private void buildLayout(int columns) {
        this.headerBoxes = new HashMap<CsvField, JComboBox>();
        int size = this.toSelect.size();
        int boxesPerColumn = size / columns;
        if (size % columns != 0) {
            ++boxesPerColumn;
        }
        Iterator<CsvField> iterator = this.toSelect.iterator();
        while (iterator.hasNext()) {
            JPanel innerPanel = new JPanel(new SpringLayout());
            for (int i = 0; i < boxesPerColumn; ++i) {
                if (iterator.hasNext()) {
                    CsvField csvField = iterator.next();
                    innerPanel.add(new JLabel(csvField.getName()));
                    JComboBox<String> comboBox = new JComboBox<String>();
                    if (!csvField.isRequired()) {
                        comboBox.addItem("");
                    }
                    for (String h : this.header) {
                        comboBox.addItem(h);
                    }
                    innerPanel.add(comboBox);
                    this.headerBoxes.put(csvField, comboBox);
                    continue;
                }
                innerPanel.add(new JPanel());
                innerPanel.add(new JPanel());
            }
            SpringUtilities.makeCompactGrid(innerPanel, boxesPerColumn, 2, 5, 5, 10, 2);
            JPanel northPanel = new JPanel(new BorderLayout());
            northPanel.add((Component)innerPanel, "North");
            this.add(northPanel);
        }
        this.setLayout(new GridLayout(1, columns));
    }

    public Map<Serializable, String> getSelectedValues() {
        LinkedHashMap<Serializable, String> map = new LinkedHashMap<Serializable, String>();
        for (CsvField csvField : this.toSelect) {
            JComboBox comboBox = this.headerBoxes.get(csvField);
            String value = !csvField.isRequired() && comboBox.getSelectedIndex() == 0 ? null : (String)comboBox.getSelectedItem();
            map.put(csvField.getKey(), value);
        }
        return map;
    }

    public static class CsvField {
        private Serializable key;
        private String name;
        private boolean required;

        public CsvField(Serializable key, String name, boolean requried) {
            this.key = key;
            this.name = name;
            this.required = requried;
        }

        public Serializable getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CsvField) {
                CsvField other = (CsvField)obj;
                return new EqualsBuilder().append(this.getKey(), other.getKey()).isEquals();
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.getKey()).toHashCode();
        }
    }
}

