/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.swing.csv;

import de.datomino.util.swing.SwingUtils;
import de.datomino.util.swing.csv.CsvHeaderChooserPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public abstract class CsvHeaderChooserDialog
extends JDialog {
    private static final long serialVersionUID = 4663464095180554517L;
    private CsvHeaderChooserPane csvHeaderChooserPane;

    public CsvHeaderChooserDialog(Window owner, Collection<CsvHeaderChooserPane.CsvField> csvFields, List<String> header, int columns) {
        super(owner, "CSV Feld Auswahl");
        this.buildLayout(owner, csvFields, header, columns);
    }

    public CsvHeaderChooserDialog(Window owner, Dialog.ModalityType modalityType, Collection<CsvHeaderChooserPane.CsvField> csvFields, List<String> header, int columns) {
        super(owner, "CSV Feld Auswahl", modalityType);
        this.buildLayout(owner, csvFields, header, columns);
    }

    private void buildLayout(Window owner, Collection<CsvHeaderChooserPane.CsvField> csvFields, List<String> header, int columns) {
        this.getContentPane().setLayout(new BorderLayout());
        Component special = this.getSpecialNorthComponent();
        if (special != null) {
            this.getContentPane().add(special, "North");
        }
        this.csvHeaderChooserPane = new CsvHeaderChooserPane(csvFields, header, columns);
        this.csvHeaderChooserPane.setBorder(new TitledBorder("Felder"));
        this.getContentPane().add((Component)this.csvHeaderChooserPane, "Center");
        JPanel panel = new JPanel(new BorderLayout());
        JPanel panel2 = new JPanel(new FlowLayout());
        JButton cancel = new JButton("Abbrechen");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CsvHeaderChooserDialog.this.dispose();
            }
        });
        panel2.add(cancel);
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CsvHeaderChooserDialog.this.doOkAction();
            }
        });
        panel2.add(ok);
        panel.add((Component)panel2, "East");
        this.getContentPane().add((Component)panel, "South");
        this.setResizable(false);
        this.pack();
        SwingUtils.centerDialog(this, owner);
    }

    protected CsvHeaderChooserPane getCsvHeaderChooserPane() {
        return this.csvHeaderChooserPane;
    }

    protected abstract void doOkAction();

    protected abstract Component getSpecialNorthComponent();
}

