/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.swing.blocking;

import de.datomino.util.swing.blocking.BusyDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSwingWorkAction<T, V>
extends AbstractAction {
    private static final long serialVersionUID = -1478107008670455116L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSwingWorkAction.class);
    private Window owner;
    private BusyDialog busyDialog;

    public AbstractSwingWorkAction(String name, Window owner) {
        super(name);
        this.owner = owner;
    }

    protected abstract V actionPerformedInternal(ActionEvent var1, T var2);

    protected abstract JButton getCancelButton();

    @Override
    public void actionPerformed(final ActionEvent e) {
        final T t = this.prepare();
        if (this.busyDialog != null) {
            BufferedImage image;
            try {
                image = ImageIO.read(AbstractSwingWorkAction.class.getResourceAsStream("/images/pepper.png"));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            this.busyDialog = new BusyDialog(this.owner, "", image){
                private static final long serialVersionUID = 6867914041912944070L;

                @Override
                public JButton getCancelButton() {
                    return AbstractSwingWorkAction.this.getCancelButton();
                }
            };
            final SwingWorker worker = new SwingWorker<V, Void>(){

                @Override
                protected V doInBackground() throws Exception {
                    return AbstractSwingWorkAction.this.actionPerformedInternal(e, t);
                }
            };
            worker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("state") && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                        AbstractSwingWorkAction.this.busyDialog.dispose();
                        try {
                            AbstractSwingWorkAction.this.doAfter(worker.get());
                        }
                        catch (InterruptedException | ExecutionException e) {
                            LOGGER.error("", e);
                        }
                    }
                }
            });
            worker.execute();
            this.busyDialog.setVisible(true);
        } else {
            this.actionPerformedInternal(e, t);
            this.doAfter(null);
        }
    }

    protected T prepare() {
        return null;
    }

    protected void doAfter(V v) {
    }

    public void setMessage(String message, Integer progress) {
        if (this.busyDialog != null) {
            this.busyDialog.setMessage(message, progress);
        }
    }
}

