/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyListener;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;

public final class SwingUtils {
    private SwingUtils() {
    }

    public static void centerDialog(JDialog dialog, Component parent) {
        SwingUtils.center((Window)dialog, parent);
    }

    public static void center(Window window) {
        Component parent = null;
        SwingUtils.center(window, parent);
    }

    public static void center(Window window, Component parent) {
        if (parent == null || !parent.isShowing()) {
            Rectangle rect = SwingUtils.getGraphicRect();
            if (rect != null) {
                SwingUtils.center(window, rect);
            }
        } else {
            Rectangle rect = SwingUtils.getRectFromComp(parent);
            SwingUtils.center(window, rect);
        }
    }

    private static Rectangle getGraphicRect() {
        GraphicsDevice[] gsArray;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gs : gsArray = ge.getScreenDevices()) {
            if (gs.getType() != 0) continue;
            GraphicsConfiguration[] gcArray = gs.getConfigurations();
            Rectangle rect = gcArray[0].getBounds();
            return rect;
        }
        return null;
    }

    private static void center(Window window, Rectangle parent) {
        double pX = parent.getX();
        double pY = parent.getY();
        double x = Math.max(pX, pX + parent.getWidth() / 2.0 - (double)window.getWidth() / 2.0);
        double y = Math.max(pY, pY + parent.getHeight() / 2.0 - (double)window.getHeight() / 2.0);
        window.setLocation((int)Math.round(x), (int)Math.round(y));
    }

    public static void topRightDialog(JDialog dialog, Component parent) {
        SwingUtils.topRightRect(dialog, parent);
    }

    public static void topRightRect(Window window, Component parent) {
        if (parent == null) {
            Rectangle rect = SwingUtils.getGraphicRect();
            if (rect != null) {
                SwingUtils.topRight(window, rect);
            }
        } else {
            Rectangle rect = SwingUtils.getRectFromComp(parent);
            SwingUtils.topRight(window, rect);
        }
    }

    private static Rectangle getRectFromComp(Component parent) {
        return new Rectangle((int)parent.getLocationOnScreen().getX(), (int)parent.getLocationOnScreen().getY(), parent.getWidth(), parent.getHeight());
    }

    private static void topRight(Window window, Rectangle parent) {
        double pX = parent.getX();
        double pY = parent.getY();
        double x = Math.max(pX, pX + parent.getWidth() - (double)window.getWidth());
        double y = Math.max(pY, pY - (double)window.getHeight());
        window.setLocation((int)x, (int)y);
    }

    public static <C extends Component> C findParentClass(Component component, Class<C> clazz) {
        if (component == null) {
            return null;
        }
        if (clazz.isInstance(component)) {
            return (C)component;
        }
        return SwingUtils.findParentClass(component.getParent(), clazz);
    }

    public static Window findWindowParent(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        return SwingUtils.findWindowParent(component.getParent());
    }

    public static JInternalFrame findInternalFrameParent(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof JInternalFrame) {
            return (JInternalFrame)component;
        }
        return SwingUtils.findInternalFrameParent(component.getParent());
    }

    public static void setPreferredSizeToPercentageOfParent(Component comp, Component parent, Double width, Double height) {
        Rectangle rect;
        Rectangle rectangle = rect = parent == null ? SwingUtils.getGraphicRect() : SwingUtils.getRectFromComp(parent);
        if (rect != null) {
            Dimension preferredSizeDim = comp.getPreferredSize();
            Dimension nP = new Dimension(preferredSizeDim);
            double oPWidth = preferredSizeDim.getWidth();
            double nWidth = width == null ? oPWidth : rect.getWidth() * (width / 100.0);
            nWidth = Math.min(nWidth, oPWidth);
            double oPHeight = preferredSizeDim.getHeight();
            double nHeight = height == null ? oPHeight : rect.getHeight() * (height / 100.0);
            nHeight = Math.min(nHeight, oPHeight);
            nP.setSize(nWidth, nHeight);
            comp.setPreferredSize(nP);
        }
    }

    public static boolean isModalDialogShowing() {
        Window[] windows = Window.getWindows();
        if (windows != null) {
            for (Window w : windows) {
                if (!w.isShowing() || !(w instanceof Dialog) || !((Dialog)w).isModal()) continue;
                return true;
            }
        }
        return false;
    }

    public static void addKeyListenerRek(Component comp, KeyListener keyListener) {
        comp.addKeyListener(keyListener);
        if (comp instanceof Container) {
            Container con = (Container)comp;
            for (int i = 0; i < con.getComponentCount(); ++i) {
                SwingUtils.addKeyListenerRek(con.getComponent(i), keyListener);
            }
        }
    }
}

