/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.swing;

import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import org.ktde.swing.ButtonBox;
import org.ktde.util.StringUtil;

public class ExceptionMessageDialog
extends JDialog {
    private static final long serialVersionUID = -226312658514326741L;
    private Throwable throwable;
    private String stackTrace;
    private JCheckBox showStack;

    public ExceptionMessageDialog(Window parent, Throwable throwable, Image iconImage) {
        super(parent, ExceptionMessageDialog.getMessage(throwable), Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(true);
        this.throwable = throwable;
        this.getContentPane().setLayout(new SpringLayout());
        this.buildLayout(false);
        if (iconImage != null) {
            this.setIconImage(iconImage);
        }
        this.pack();
        SwingUtils.center((Window)this, parent);
    }

    private void buildLayout(boolean showStackBoolean) {
        Container mainPanel = this.getContentPane();
        mainPanel.removeAll();
        JLabel label = new JLabel(ExceptionMessageDialog.getMessage(this.throwable));
        mainPanel.add(label);
        this.showStack = new JCheckBox("Details", showStackBoolean);
        mainPanel.add(this.showStack);
        this.showStack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExceptionMessageDialog.this.changeStackTraceView();
            }
        });
        if (showStackBoolean) {
            mainPanel.add(this.createStackTraceArea());
        }
        JButton button = new JButton(new AbstractAction("Ok"){
            private static final long serialVersionUID = 1117777171675787686L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExceptionMessageDialog.this.doOk();
            }
        });
        ButtonBox buttonBox = new ButtonBox();
        buttonBox.add(button);
        mainPanel.add(buttonBox);
        SpringUtilities.makeCompactGrid(mainPanel, 3 + (showStackBoolean ? 1 : 0), 1, 5, 5, 2, 2);
    }

    private JComponent createStackTraceArea() {
        if (this.stackTrace == null) {
            StringBuilder sb = new StringBuilder(this.throwable.getClass().toString()).append(": ").append(this.throwable.getMessage());
            this.buildStackTrace(sb, this.throwable, new HashSet<Throwable>());
            this.stackTrace = sb.toString();
        }
        JTextArea text = new JTextArea(this.stackTrace);
        text.setEditable(false);
        return new JScrollPane(text);
    }

    private void buildStackTrace(StringBuilder sb, Throwable t, Set<Throwable> alreadyVisited) {
        for (StackTraceElement stackTraceElement : t.getStackTrace()) {
            String className = stackTraceElement.getClassName();
            sb.append("\nat ").append(className).append(".").append(stackTraceElement.getMethodName()).append("(").append(stackTraceElement.getFileName()).append(":").append(stackTraceElement.getLineNumber()).append(")");
        }
        alreadyVisited.add(t);
        Throwable cause = t.getCause();
        if (cause != null && !alreadyVisited.contains(cause)) {
            sb.append("\nCaused by: ").append(cause.getClass().toString()).append(": ").append(cause.getMessage());
            this.buildStackTrace(sb, cause, alreadyVisited);
        }
    }

    private void changeStackTraceView() {
        boolean showStackBoolean = this.showStack != null && this.showStack.isSelected();
        this.buildLayout(showStackBoolean);
        int width = this.getWidth();
        int height = this.getHeight();
        this.pack();
        if (showStackBoolean) {
            int newHeight = this.getHeight();
            this.setSize(width, Math.min(newHeight, height * 3));
        }
        this.repaint(1L);
    }

    protected void doOk() {
        this.dispose();
    }

    private static String getMessage(Throwable throwable) {
        String message = throwable.getLocalizedMessage();
        if (StringUtil.isBlank(message) && StringUtil.isBlank(message = throwable.getMessage())) {
            message = "Keine Meldung verf\u00fcgbar";
        }
        return message;
    }
}

