/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.swing;

import de.datomino.util.message.Message;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ErrorMessageDialog
extends JDialog {
    private static final long serialVersionUID = 3304441161765763509L;

    public ErrorMessageDialog(Window owner, MessageResolver messageResolver, ErrorMessages errorMessages, Image iconImage) {
        this(owner, messageResolver, errorMessages, new Message("messages.default.error"), new Message("messages.default.ok"), iconImage);
    }

    public ErrorMessageDialog(Window owner, MessageResolver messageResolver, ErrorMessages errorMessages, Message title, Message buttonMessage, Image iconImage) {
        super(owner, messageResolver.resolveMessage(title), Dialog.ModalityType.APPLICATION_MODAL);
        this.buildLayout(errorMessages, messageResolver, buttonMessage, iconImage);
        this.pack();
        SwingUtils.center((Window)this, owner);
    }

    private void buildLayout(ErrorMessages errorMessages, MessageResolver messageResolver, Message buttonMessage, Image iconImage) {
        if (iconImage != null) {
            this.setIconImage(iconImage);
        }
        this.getContentPane().setLayout(new BorderLayout());
        JTextArea errors = new JTextArea(10, 30);
        errors.setText(messageResolver.resolveMessages(errorMessages, "\n"));
        this.getContentPane().add((Component)new JScrollPane(errors), "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JButton button = new JButton(new AbstractAction(messageResolver.resolveMessage(buttonMessage)){
            private static final long serialVersionUID = 4599709041287379079L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorMessageDialog.this.dispose();
            }
        });
        buttonPanel.add((Component)button, "East");
        this.getContentPane().add((Component)buttonPanel, "South");
    }
}

