/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.resolver;

import de.datomino.util.resolver.ValueResolver;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.ktde.util.StringUtil;

public class DateResolver
implements ValueResolver<Date, String> {
    private static final DateResolver INSTANCE = new DateResolver();
    private static final String[] FORMATS = new String[0];

    protected DateResolver() {
    }

    @Override
    public Date resolve(String value, String hint) {
        return this.resolve(value, new String[]{hint});
    }

    private Date parse(String value, String format) {
        if (!StringUtil.isBlank(format)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
            try {
                return simpleDateFormat.parse(value);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    public static DateResolver getInstance() {
        return INSTANCE;
    }

    @Override
    public Date resolve(String value, String ... hints) {
        String[][] formatArrays;
        Date date = null;
        String[][] stringArrayArray = formatArrays = new String[][]{hints, FORMATS};
        int n = stringArrayArray.length;
        block0: for (int i = 0; i < n; ++i) {
            String[] formatArray;
            for (String format : formatArray = stringArrayArray[i]) {
                date = this.parse(value, format);
                if (date != null) break block0;
            }
        }
        return date;
    }
}

