/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.message;

import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.message.Message;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.message.error.ErrorMessage;
import de.datomino.util.message.error.ErrorMessages;
import java.io.IOException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ktde.util.StringUtil;
import org.springframework.core.io.Resource;

public class MessageResolverImpl
implements MessageResolver {
    private static final Pattern ARG_PATTERN = Pattern.compile("%(?:\\{\\d+\\}|\\d+)");
    private static final String VARIABLE = "[a-zA-Z_][a-zA-Z0-9._-]*";
    private static final Pattern VAR_PATTERN = Pattern.compile("%(?:\\{[a-zA-Z_][a-zA-Z0-9._-]*\\}|[a-zA-Z_][a-zA-Z0-9._-]*)");
    private static final Pattern VAR_PARAMETRIZED_PATTERN = Pattern.compile("%\\{[a-zA-Z_][a-zA-Z0-9._-]*\\([^}]*\\)\\}");
    private static final List<String> DELIMS = CollectionUtil.buildArrayList("-", "/");
    private Resource resource;
    private String locale;
    private String localeFallback = "en";
    private List<String> prefixes;
    private Properties properties;
    private Properties fallBackProperties;
    private boolean initialized = false;

    @Override
    public String resolveMessage(String key, Serializable ... args) {
        Serializable[] fargs;
        Serializable[] serializableArray = fargs = args == null ? new Serializable[]{} : args;
        if (!this.initialized) {
            this.initialize();
        }
        String unparsedMessage = null;
        if (this.properties != null && key != null) {
            unparsedMessage = this.properties.getProperty(key);
        }
        if (unparsedMessage == null && this.fallBackProperties != null && key != null) {
            unparsedMessage = this.fallBackProperties.getProperty(key);
        }
        if (unparsedMessage == null) {
            return key + " - [" + StringUtil.implode(args, ", ") + "]";
        }
        String message1 = MessageResolverImpl.getMessage(unparsedMessage, VAR_PATTERN, new Transformer<String, String>(){

            @Override
            public String transform(String t) {
                if (t.startsWith("{")) {
                    t = t.replaceAll("[{} ]", "");
                }
                return MessageResolverImpl.this.resolveMessage(t, new Serializable[0]);
            }
        });
        String message2 = MessageResolverImpl.getMessage(message1, VAR_PARAMETRIZED_PATTERN, new Transformer<String, String>(){

            @Override
            public String transform(String t) {
                if (t.startsWith("{")) {
                    t = t.replaceAll("[{} ]", "");
                }
                String[] parts = t.split("\\(");
                parts[1] = parts[1].split("\\)")[0];
                String[] params = parts[1].split(",");
                for (int i = 0; i < params.length; ++i) {
                    params[i] = params[i].trim();
                    params[i] = "%{" + params[i].substring(1) + "}";
                }
                return MessageResolverImpl.this.resolveMessage(parts[0].trim(), (Serializable[])params);
            }
        });
        String resolved = MessageResolverImpl.getMessage(message2, ARG_PATTERN, new Transformer<String, String>(){

            @Override
            public String transform(String t) {
                int argIndex;
                if (t.startsWith("{")) {
                    t = t.replaceAll("[{} ]", "");
                }
                Object argValue = (argIndex = Integer.parseInt(t)) < 0 || argIndex >= fargs.length ? "%" + argIndex : fargs[argIndex];
                return argValue == null ? "" : argValue.toString();
            }
        });
        return resolved;
    }

    @Override
    public String resolveMessages(List<String> keys, String ... args) {
        String separator = "";
        for (String arg : args) {
            separator = separator + arg;
        }
        if (separator.length() == 0) {
            separator = " ";
        }
        String resolved = "";
        for (String key : keys) {
            String resolveMessage;
            String string = resolveMessage = DELIMS.contains(key) ? key : this.resolveMessage(key, new Serializable[0]);
            if (resolveMessage.trim().startsWith("- [") && resolveMessage.endsWith("]")) {
                resolveMessage = resolveMessage.substring(5, resolveMessage.length() - 1);
            }
            if (resolved.length() != 0) {
                resolved = resolved + separator;
            }
            resolved = resolved + resolveMessage;
        }
        return resolved.trim();
    }

    private static String getMessage(String unparsed, Pattern pattern, Transformer<String, String> transformer) {
        Matcher matcher = pattern.matcher(unparsed);
        int currentStart = 0;
        StringBuilder resolvedMessage = new StringBuilder();
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            resolvedMessage.append(unparsed.substring(currentStart, start));
            resolvedMessage.append(transformer.transform(unparsed.substring(start + 1, end)));
            currentStart = end;
        }
        resolvedMessage.append(unparsed.substring(currentStart, unparsed.length()));
        return resolvedMessage.toString();
    }

    @Override
    public String resolveMessages(ErrorMessages errorMessages, String glue) {
        List<ErrorMessage> errorMessageList = errorMessages.getErrorMessages();
        ArrayList<String> resolved = new ArrayList<String>(errorMessageList.size());
        for (Message message : errorMessageList) {
            resolved.add(this.resolveMessage(message));
        }
        return StringUtil.implode(resolved, glue);
    }

    @Override
    public String resolveMessages(ErrorMessages errorMessages, String glue, int maxNumberOfDetailedMessages) {
        List<ErrorMessage> errorMessageList = errorMessages.getErrorMessages();
        ArrayList<String> resolved = new ArrayList<String>(Math.min(errorMessageList.size(), maxNumberOfDetailedMessages + 1));
        Iterator<ErrorMessage> iterator = errorMessageList.iterator();
        for (int i = 0; iterator.hasNext() && i < maxNumberOfDetailedMessages; ++i) {
            resolved.add(this.resolveMessage(iterator.next()));
        }
        int overhead = errorMessageList.size() - maxNumberOfDetailedMessages;
        if (0 < overhead) {
            resolved.add(this.resolveMessage("errors.import.error.furtherErrors", Integer.valueOf(overhead)));
        }
        return StringUtil.implode(resolved, glue);
    }

    @Override
    public String resolveMessage(Message message) {
        return this.resolveMessage(message.getMessageKey(), message.getArgs());
    }

    @Override
    public List<String> resolveMessages(Collection<? extends Message> messages) {
        ArrayList<String> messageList = new ArrayList<String>(messages.size());
        for (Message message : messages) {
            messageList.add(this.resolveMessage(message));
        }
        return messageList;
    }

    private void initialize() {
        try {
            List<Resource> realResources = this.getResources(this.locale);
            this.properties = new Properties();
            for (Resource realResource : realResources) {
                if (!realResource.exists()) continue;
                this.properties.load(realResource.getInputStream());
            }
            List<Resource> fallbackResources = this.getResources(this.localeFallback);
            this.fallBackProperties = new Properties();
            for (Resource fallbackResource : fallbackResources) {
                if (!fallbackResource.exists()) continue;
                this.fallBackProperties.load(fallbackResource.getInputStream());
            }
            this.initialized = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Resource> getResources(String locale) throws IOException {
        LinkedList<Resource> resources = new LinkedList<Resource>();
        for (String prefix : this.prefixes) {
            String resourceName = prefix + "_" + locale + ".properties";
            resources.add(this.resource.createRelative(resourceName));
        }
        return resources;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
        this.initialized = false;
    }

    public void setLocale(String locale) {
        this.locale = locale;
        this.initialized = false;
    }

    public void setLocaleFallback(String localeFallback) {
        this.localeFallback = localeFallback;
        this.initialized = false;
    }

    public void setPrefixes(List<String> prefixes) {
        this.prefixes = prefixes;
    }

    @Override
    public String getLocaleString() {
        return this.locale;
    }

    @Override
    public NumberFormat getNumberFormat() {
        Locale l = Locale.ENGLISH;
        if (this.locale.equalsIgnoreCase("de")) {
            l = Locale.GERMANY;
        }
        return NumberFormat.getNumberInstance(l);
    }

    @Override
    public String resolveMessageForEnum(Enum<?> e, Serializable ... args) {
        if (e == null) {
            return "";
        }
        String key = e.getClass().getName().replace('$', '.') + "." + e.name();
        return this.resolveMessage(key, args);
    }

    @Override
    public String resolveMessageForEnum(Enum<?> e) {
        return this.resolveMessageForEnum(e, new Serializable[0]);
    }

    @Override
    public String resolveMessageForEnum(Class<? extends Enum<?>> clazz) {
        String key = clazz.getName().replace('$', '.');
        return this.resolveMessage(key, new Serializable[0]);
    }
}

