/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.math;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.triangulate.VoronoiDiagramBuilder;
import de.datomino.util.geo.GeomObject;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.ktde.math.projection.GeoDecimalFactory;

public class VoronoiDiagramm {
    private Set<GeomObject<ImmutablePoint>> points = new LinkedHashSet<GeomObject<ImmutablePoint>>();
    private Map<GeomObject<ImmutablePoint>, ImmutablePolygon> result;

    public void add(GeomObject<ImmutablePoint> geomObject) {
        this.points.add(geomObject);
    }

    public boolean remove(GeomObject<ImmutablePoint> geomObject) {
        return this.points.remove(geomObject);
    }

    public void addAll(Collection<GeomObject<ImmutablePoint>> geoObject) {
        this.points.addAll(geoObject);
    }

    public Map<GeomObject<ImmutablePoint>, ImmutablePolygon> getResult() {
        return this.result;
    }

    public void calculate() {
        VoronoiDiagramBuilder voronoiDiagramBuilder = new VoronoiDiagramBuilder();
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>(this.points.size());
        for (GeomObject<ImmutablePoint> geomObject : this.points) {
            coords.add(geomObject.getGeom().getGeometryClone(GeoDecimalFactory.INSTANCE).getCoordinate());
        }
        voronoiDiagramBuilder.setSites(coords);
        voronoiDiagramBuilder.setTolerance(0.0);
    }
}

