/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.log;

import de.datomino.log.ServletContextBasedFileAppender;
import java.io.File;
import java.io.IOException;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContextBasedAppenderInitializeServlet
extends GenericServlet {
    private static final long serialVersionUID = -9073825911861225512L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletContextBasedAppenderInitializeServlet.class);
    private static File servletDir;

    @Override
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
    }

    @Override
    public void init() throws ServletException {
        super.init();
        servletDir = new File(this.getServletContext().getRealPath("/"));
        String logfile = servletDir.getName() + ".log";
        ServletContextBasedFileAppender.setLoggingRootDir(System.getProperty("root.log.dir"));
        ServletContextBasedFileAppender.setServletContextBasedFile(logfile);
        final Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOGGER.error(e.getMessage(), e);
                if (uncaughtExceptionHandler != null) {
                    uncaughtExceptionHandler.uncaughtException(t, e);
                }
            }
        });
    }

    public static File getServletDir() {
        return servletDir;
    }
}

