/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;

public class TimeoutInputstream
extends InputStream {
    private InputStream delegate;
    private int timeout;

    public TimeoutInputstream(InputStream delegate, int timeout) {
        this.delegate = delegate;
        this.timeout = timeout;
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    @Override
    public int read() throws IOException {
        long now = System.currentTimeMillis();
        while (this.available() < 1) {
            if (System.currentTimeMillis() - now > (long)this.timeout) {
                throw new SocketTimeoutException();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.delegate.read();
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

