/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LongArrayCoder {
    public static void writeLongArray(long[] array, OutputStream os) throws IOException {
        if (array == null) {
            os.write(0);
        } else {
            os.write(1);
            int lMask = 255;
            int length = array.length;
            for (int j = 0; j < 4; ++j) {
                int lMasked = lMask & length;
                os.write(lMasked);
                length >>>= 8;
            }
            for (int i = 0; i < array.length; ++i) {
                long value = array[i];
                long mask = 255L;
                for (int j = 0; j < 8; ++j) {
                    long masked = mask & value;
                    os.write((int)masked);
                    value >>>= 8;
                }
            }
        }
    }

    public static long[] readLongArray(InputStream in) throws IOException {
        int c = in.read();
        if (c == 0) {
            return null;
        }
        int length = 0;
        int shift = 0;
        for (int j = 0; j < 4; ++j) {
            int r = in.read();
            length |= (r <<= shift);
            shift += 8;
        }
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            long value = 0L;
            shift = 0;
            for (int j = 0; j < 8; ++j) {
                long r = in.read();
                value |= (r <<= shift);
                shift += 8;
            }
            array[i] = value;
        }
        return array;
    }

    public static byte[] toByteArray(long[] array) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(array == null ? 1 : 5 + array.length * 8);
        try {
            LongArrayCoder.writeLongArray(array, baos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }
}

