/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.util;

import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.GeoUtils;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.datatypes.Tupel;

public class Straight {
    public ImmutablePoint basePoint;
    public double vx;
    public double vy;

    public Straight(ImmutablePoint basePoint, double vx, double vy) {
        this.basePoint = basePoint;
        this.vx = vx;
        this.vy = vy;
    }

    public Tupel<ImmutablePoint, Boolean> cut(Straight other) {
        CoordinateFactory coordinateFactory = this.basePoint.getCoordinateFactory();
        ImmutablePoint otherBasePoint = (ImmutablePoint)other.basePoint.getTransformed(coordinateFactory);
        double n = other.vx * this.vy - other.vy * this.vx;
        if (n == 0.0) {
            boolean equal = GeoUtils.isPointOnLine(otherBasePoint, this.basePoint, ImmutableGeoObjectFactory.createImmutablePoint(coordinateFactory.createCoordinate(this.basePoint.getX() + this.vx, this.basePoint.getY() + this.vy)), 1.0E-12);
            return new Tupel<Object, Boolean>(null, equal);
        }
        double s = this.vx * otherBasePoint.getY() - this.basePoint.getY() * this.vx - this.vy * otherBasePoint.getX() + this.vy * this.basePoint.getX();
        return new Tupel<ImmutablePoint, Object>(ImmutableGeoObjectFactory.createImmutablePoint(coordinateFactory.createCoordinate(otherBasePoint.getX() + other.vx * (s /= n), otherBasePoint.getY() + other.vy * s)), null);
    }
}

