/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.util;

import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.GeoUtils;
import java.util.Iterator;
import java.util.List;
import org.ktde.math.helper.ComputeTrigonometrics;
import org.ktde.math.projection.Coordinate;

public class BasedPoint
implements Comparable<BasedPoint> {
    private ImmutablePoint refPoint;
    private ImmutablePoint basePoint;
    private ImmutableLineString baseLine;
    private double distanceToBaseLine;
    private GeoUtils.Relation relation;
    private double distanceOnBaseline;
    private ImmutableLineString baseToRefLine;
    private ImmutableLineString basePointContainingPart;

    public BasedPoint(ImmutablePoint refPoint, ImmutablePoint basePoint, ImmutableLineString baseLine, double distanceToBaseLine, GeoUtils.Relation relation, double distanceOnBaseline) {
        this.refPoint = refPoint;
        this.basePoint = basePoint;
        this.baseLine = baseLine;
        this.distanceToBaseLine = distanceToBaseLine;
        this.relation = relation;
        this.distanceOnBaseline = distanceOnBaseline;
    }

    public ImmutablePoint getRefPoint() {
        return this.refPoint;
    }

    public ImmutablePoint getBasePoint() {
        return this.basePoint;
    }

    public ImmutableLineString getBaseLine() {
        return this.baseLine;
    }

    public double getDistanceToBaseLine() {
        return this.distanceToBaseLine;
    }

    public GeoUtils.Relation getRelation() {
        return this.relation;
    }

    public double getDistanceOnBaseline() {
        return this.distanceOnBaseline;
    }

    public ImmutableLineString getBaseToRefLine() {
        if (this.baseToRefLine == null) {
            this.baseToRefLine = ImmutableGeoObjectFactory.createImmutableLineStringByPoints(this.basePoint, this.refPoint, new ImmutablePoint[0]);
        }
        return this.baseToRefLine;
    }

    public ImmutableLineString getBasePointContainingPart() {
        if (this.basePointContainingPart == null) {
            ImmutablePoint succ;
            double walkedDistance = 0.0;
            Iterator<ImmutablePoint> iter = this.baseLine.getCoordinates().iterator();
            ImmutablePoint succSucc = succ = iter.next();
            while (iter.hasNext()) {
                ImmutablePoint pred = iter.next();
                double distance = succ.distance(pred);
                if (walkedDistance + distance >= this.distanceOnBaseline) {
                    this.basePointContainingPart = ImmutableGeoObjectFactory.createImmutableLineStringByPoints(succ, pred, new ImmutablePoint[0]);
                    break;
                }
                walkedDistance += distance;
                succSucc = succ;
                succ = pred;
            }
            if (this.basePointContainingPart == null) {
                this.basePointContainingPart = ImmutableGeoObjectFactory.createImmutableLineStringByPoints(succSucc, succ, new ImmutablePoint[0]);
            }
        }
        return this.basePointContainingPart;
    }

    @Override
    public int compareTo(BasedPoint o) {
        switch (this.getRelation()) {
            case INTERVAL_AFTER: {
                if (o.getRelation() == GeoUtils.Relation.INTERVAL_AFTER) {
                    Coordinate baseCoordinate = this.getBasePoint().getCoordinate();
                    List<ImmutablePoint> coords = this.getBaseLine().getCoordinates();
                    Coordinate lastCoordinate = coords.get(coords.size() - 2).getCoordinate();
                    Coordinate refCoordinate = this.getRefPoint().getCoordinate();
                    double thisAngle = ComputeTrigonometrics.angleBetween(baseCoordinate.getX(), baseCoordinate.getY(), lastCoordinate.getX(), lastCoordinate.getY(), refCoordinate.getX(), refCoordinate.getY());
                    Coordinate otherRefCoordinate = o.getRefPoint().getCoordinate();
                    double otherAngle = ComputeTrigonometrics.angleBetween(baseCoordinate.getX(), baseCoordinate.getY(), lastCoordinate.getX(), lastCoordinate.getY(), otherRefCoordinate.getX(), otherRefCoordinate.getY());
                    int d = Double.compare(otherAngle, thisAngle);
                    return d == 0 ? Double.compare(o.getDistanceToBaseLine(), this.getDistanceToBaseLine()) : d;
                }
                return 1;
            }
            case INTERVAL_BEFORE: {
                if (o.getRelation() == GeoUtils.Relation.INTERVAL_BEFORE) {
                    Coordinate baseCoordinate = this.getBasePoint().getCoordinate();
                    Coordinate firstCoordinate = this.getBaseLine().getCoordinates().get(1).getCoordinate();
                    Coordinate refCoordinate = this.getRefPoint().getCoordinate();
                    double thisAngle = ComputeTrigonometrics.angleBetween(baseCoordinate.getX(), baseCoordinate.getY(), firstCoordinate.getX(), firstCoordinate.getY(), refCoordinate.getX(), refCoordinate.getY());
                    Coordinate otherRefCoordinate = o.getRefPoint().getCoordinate();
                    double otherAngle = ComputeTrigonometrics.angleBetween(baseCoordinate.getX(), baseCoordinate.getY(), firstCoordinate.getX(), firstCoordinate.getY(), otherRefCoordinate.getX(), otherRefCoordinate.getY());
                    int d = Double.compare(otherAngle, thisAngle);
                    return d == 0 ? Double.compare(o.getDistanceToBaseLine(), this.getDistanceToBaseLine()) : d;
                }
                return -1;
            }
        }
        int d = Double.compare(this.getDistanceOnBaseline(), o.getDistanceOnBaseline());
        if (d == 0) {
            Coordinate baseCoordinate = this.getBasePoint().getCoordinate();
            List<ImmutablePoint> coords = this.getBaseLine().getCoordinates();
            Coordinate lastCoordinate = coords.get(coords.size() - 2).getCoordinate();
            Coordinate refCoordinate = this.getRefPoint().getCoordinate();
            double thisAngle = ComputeTrigonometrics.angleBetween(baseCoordinate.getX(), baseCoordinate.getY(), lastCoordinate.getX(), lastCoordinate.getY(), refCoordinate.getX(), refCoordinate.getY());
            Coordinate otherRefCoordinate = o.getRefPoint().getCoordinate();
            double otherAngle = ComputeTrigonometrics.angleBetween(baseCoordinate.getX(), baseCoordinate.getY(), lastCoordinate.getX(), lastCoordinate.getY(), otherRefCoordinate.getX(), otherRefCoordinate.getY());
            int sd = Double.compare(otherAngle, thisAngle);
            return sd == 0 ? Double.compare(o.getDistanceToBaseLine(), this.getDistanceToBaseLine()) : sd;
        }
        return d;
    }
}

