/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing.renderer;

import de.datomino.util.geo.swing.PaintUtil;
import de.datomino.util.geo.swing.renderer.AbstractAreaRenderer;
import de.datomino.util.geo.swing.renderer.AreaRenderer;
import de.datomino.util.geo.swing.renderer.DefaultRendererProperties;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;

public class PlainAreaRenderer<U>
extends AbstractAreaRenderer<RendererProperties, U> {
    private Color fixedColor;

    public PlainAreaRenderer(Color fixedColor, Integer alpha, AreaRenderer<? extends RendererProperties, U> emphasizeRenderer) {
        super(emphasizeRenderer);
        if (fixedColor == null) {
            fixedColor = Color.BLUE;
        }
        if (alpha == null) {
            alpha = 100;
        }
        this.fixedColor = new Color(fixedColor.getRed(), fixedColor.getGreen(), fixedColor.getBlue(), PaintUtil.transform100BaseAlpha(alpha));
    }

    public PlainAreaRenderer(Color fixedColor, AreaRenderer<RendererProperties, U> emphasizeRenderer) {
        this(fixedColor, fixedColor == null ? null : Integer.valueOf(fixedColor.getAlpha()), emphasizeRenderer);
    }

    @Override
    protected void configureGraphics(Graphics2D g2d, RendererProperties rendererProperties) {
        g2d.setColor(this.fixedColor);
    }

    @Override
    public RendererProperties createRendererProperties(U u) {
        return new DefaultRendererProperties();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public Dimension getOptimalPreviewDimension() {
        return new Dimension(20, 20);
    }

    @Override
    protected AreaRenderer<? extends RendererProperties, U> emphaziseDefault(U u) {
        return new PlainAreaRenderer<U>(PaintUtil.getComplementColor(this.fixedColor), PaintUtil.transform256BaseAlpha(this.fixedColor.getAlpha()), null);
    }

    public static enum Parameters {
        COLOR,
        ALPHA;

    }
}

