/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing.renderer;

import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.swing.renderer.AbstractShapePointRenderer;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import org.ktde.swing.graphics.Polygon2D;

public class IsoscelesTrianglePointRenderer<U>
extends AbstractShapePointRenderer<U> {
    private Integer baseLineLength;
    private Integer height;

    public IsoscelesTrianglePointRenderer(Color fixedColor, Integer alpha, Integer baseLineLength, Integer height) {
        super(fixedColor, alpha);
        this.baseLineLength = baseLineLength;
        this.height = height;
    }

    @Override
    protected void setParamsInternal(String[] params) {
        this.baseLineLength = Integer.valueOf(params[1]);
        this.height = Integer.valueOf(params[2]);
    }

    @Override
    public void render(Graphics2D g2d, U u, ImmutablePoint geom, RendererProperties rendererProperties) {
        this.renderInternal(g2d, geom, rendererProperties, false);
    }

    private void renderInternal(Graphics2D g2d, ImmutablePoint geom, RendererProperties rendererProperties, boolean flip) {
        Color fixedColor = this.getFixedColor();
        if (fixedColor.getAlpha() > 0) {
            Stroke setStroke = g2d.getStroke();
            Color setColor = g2d.getColor();
            g2d.setColor(fixedColor);
            g2d.setStroke(new BasicStroke((float)rendererProperties.getUpp()));
            double aHeight = (double)this.height.intValue() * rendererProperties.getUpp();
            double aBaseLineLength = (double)this.baseLineLength.intValue() * rendererProperties.getUpp();
            Polygon2D triangle = this.createTriangle(geom, aHeight, aBaseLineLength, flip);
            g2d.fill(triangle);
            g2d.setColor(Color.BLACK);
            g2d.draw(triangle);
            g2d.setColor(setColor);
            g2d.setStroke(setStroke);
        }
    }

    private Polygon2D createTriangle(ImmutablePoint geom, double aHeight, double aBaseLineLength, boolean flip) {
        Polygon2D.Double triangle = new Polygon2D.Double();
        double mul = flip ? -1.0 : 1.0;
        Point2D.Double top = new Point2D.Double(geom.getX(), geom.getY() + aHeight / 2.0 * mul);
        triangle.moveTo(top);
        triangle.lineTo(new Point2D.Double(geom.getX() - aBaseLineLength / 2.0, geom.getY() - mul * (aHeight / 2.0)));
        triangle.lineTo(new Point2D.Double(geom.getX() + aBaseLineLength / 2.0, geom.getY() - mul * aHeight / 2.0));
        triangle.lineTo(top);
        return triangle;
    }

    @Override
    public void renderForPreview(Graphics2D g2d, U u, ImmutablePoint geom, RendererProperties rendererProperties) {
        this.renderInternal(g2d, geom, rendererProperties, true);
    }

    @Override
    public Dimension getOptimalPreviewDimension() {
        return new Dimension(this.baseLineLength, this.height);
    }

    public static enum Parameters {
        COLOR,
        ALPHA,
        BASE_LINE_LENGTH,
        HEIGHT;

    }
}

