/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing.renderer;

import de.datomino.util.geo.swing.PaintUtil;
import de.datomino.util.geo.swing.renderer.AbstractAreaRenderer;
import de.datomino.util.geo.swing.renderer.AreaRenderer;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;

public class HatchQuadAreaRenderer<U>
extends AbstractAreaRenderer<HatchQuadAreaRendererProperties, U> {
    private double size;
    private Color color1;
    private Color color2;

    public HatchQuadAreaRenderer(Color color1, Integer alpha1, Color color2, Integer alpha2, Double size, AreaRenderer<? extends RendererProperties, U> emphasizeRenderer) {
        super(emphasizeRenderer);
        this.color1 = color1 == null ? Color.BLUE : color1;
        if (alpha1 != null) {
            this.color1 = new Color(this.color1.getRed(), this.color1.getGreen(), this.color1.getBlue(), PaintUtil.transform100BaseAlpha(alpha1));
        }
        this.color2 = color2 == null ? this.color1 : color2;
        if (alpha2 != null) {
            this.color2 = new Color(this.color2.getRed(), this.color2.getGreen(), this.color2.getBlue(), PaintUtil.transform100BaseAlpha((int)alpha2));
        }
        this.size = size;
    }

    @Override
    public HatchQuadAreaRendererProperties createRendererProperties(U u) {
        return new HatchQuadAreaRendererProperties();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public Dimension getOptimalPreviewDimension() {
        int squareLineLength = (int)Math.round(Math.ceil(this.size * 2.0));
        return new Dimension(squareLineLength, squareLineLength);
    }

    @Override
    protected void configureGraphics(Graphics2D g2d, HatchQuadAreaRendererProperties rendererProperties) {
        TexturePaint tp = null;
        if (this.color1 == this.color2) {
            int argb = this.color1.getRGB() & 0xFFFFFF | 0x77000000;
            g2d.setColor(new Color(argb, true));
        } else if (rendererProperties != null && rendererProperties.si1 > 1000) {
            int r = (this.color1.getRed() + this.color2.getRed()) / 2;
            int g = (this.color1.getGreen() + this.color2.getGreen()) / 2;
            int b = (this.color1.getBlue() + this.color2.getBlue()) / 2;
            int argb = r << 16 | g << 8 | b | 0x77000000;
            g2d.setColor(new Color(argb, true));
        } else {
            int si2;
            int si1;
            if (rendererProperties == null) {
                si1 = 1;
                si2 = 1;
            } else {
                si2 = rendererProperties.si2;
                si1 = rendererProperties.si1;
            }
            BufferedImage bi = new BufferedImage(si2, si2, 2);
            Graphics2D big = bi.createGraphics();
            big.setBackground(new Color(0, true));
            big.clearRect(0, 0, si2, si2);
            big.setColor(this.color1);
            big.fillRect(0, si1, si1, si1);
            big.fillRect(si1, 0, si1, si1);
            big.setColor(this.color2);
            big.fillRect(0, 0, si1, si1);
            big.fillRect(si1, si1, si1, si1);
            Rectangle r = new Rectangle(0, 0, si2, si2);
            tp = new TexturePaint(bi, r);
        }
        g2d.setPaint(tp);
    }

    @Override
    protected void resetGraphics(Graphics2D g2d) {
        g2d.setPaint(null);
    }

    @Override
    protected AreaRenderer<? extends RendererProperties, U> emphaziseDefault(U u) {
        return new HatchQuadAreaRenderer<U>(PaintUtil.getComplementColor(this.color1), PaintUtil.transform256BaseAlpha(this.color1.getAlpha()), PaintUtil.getComplementColor(this.color2), PaintUtil.transform256BaseAlpha(this.color2.getAlpha()), this.size, null);
    }

    public class HatchQuadAreaRendererProperties
    implements RendererProperties {
        private int si1;
        private int si2;
        private double upp;

        @Override
        public void setUpp(double upp) {
            this.upp = upp;
            this.si1 = (int)(HatchQuadAreaRenderer.this.size * upp);
            this.si1 = this.si1 < 1 ? 1 : (this.si1 > 100 ? 100 : this.si1);
            this.si2 = this.si1 * 2;
        }

        @Override
        public double getUpp() {
            return this.upp;
        }
    }

    public static enum Parameters {
        COLOR_1,
        ALPHA_1,
        COLOR_2,
        ALPHA_2,
        QUAD_SIZE;

    }
}

