/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing.renderer;

import de.datomino.util.geo.swing.PaintUtil;
import de.datomino.util.geo.swing.renderer.AbstractAreaRenderer;
import de.datomino.util.geo.swing.renderer.AreaRenderer;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import org.ktde.swing.graphics.Polygon2D;
import org.ktde.util.datatypes.Tripel;

public class HatchLineAreaRenderer<U>
extends AbstractAreaRenderer<HatchLineAreaRendererProperties, U> {
    private double width;
    private Color color1;
    private Color color2;
    private DirectionType directionType;

    public HatchLineAreaRenderer(Color color1, Integer alpha1, Color color2, Integer alpha2, Double width, DirectionType directionType, AreaRenderer<? extends RendererProperties, U> emphasizeRenderer) {
        super(emphasizeRenderer);
        this.color1 = color1 == null ? Color.BLUE : color1;
        if (alpha1 != null) {
            this.color1 = new Color(this.color1.getRed(), this.color1.getGreen(), this.color1.getBlue(), PaintUtil.transform100BaseAlpha(alpha1));
        }
        this.color2 = color2 == null ? this.color1 : color2;
        if (alpha2 != null) {
            this.color2 = new Color(this.color2.getRed(), this.color2.getGreen(), this.color2.getBlue(), PaintUtil.transform100BaseAlpha((int)alpha2));
        }
        this.width = width;
        this.directionType = directionType;
    }

    @Override
    public HatchLineAreaRendererProperties createRendererProperties(U u) {
        return new HatchLineAreaRendererProperties();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public Dimension getOptimalPreviewDimension() {
        int squareLineLength = (int)Math.round(Math.ceil(this.width * 4.0));
        return new Dimension(squareLineLength, squareLineLength);
    }

    @Override
    protected void configureGraphics(Graphics2D g2d, HatchLineAreaRendererProperties rendererProperties) {
        TexturePaint tp = null;
        if (this.color1 == this.color2) {
            int argb = this.color1.getRGB() & 0xFFFFFF | 0x77000000;
            g2d.setColor(new Color(argb, true));
        } else {
            int mSize = rendererProperties == null ? 1 : rendererProperties.mSize;
            Tripel<BufferedImage, Integer, Integer> tripel = null;
            switch (this.directionType) {
                case HORIZONTAL: {
                    tripel = this.createHorizontalImage(mSize);
                    break;
                }
                case VERTICAL: {
                    tripel = this.createVertical(mSize);
                    break;
                }
                case DIAGONAL_FROM_UPPER_LEFT: {
                    tripel = this.createDiagonal(mSize, true);
                    break;
                }
                case DIAGONAL_FROM_UPPER_RIGHT: {
                    tripel = this.createDiagonal(mSize, false);
                }
            }
            Rectangle r = new Rectangle(0, 0, tripel.getElement2(), tripel.getElement3());
            tp = new TexturePaint(tripel.getElement1(), r);
        }
        g2d.setPaint(tp);
    }

    private Tripel<BufferedImage, Integer, Integer> createDiagonal(int mSize, boolean fromUpperLeft) {
        int completeSize = mSize * 4;
        int tSize = mSize * 3;
        BufferedImage bi = new BufferedImage(completeSize, completeSize, 2);
        Graphics2D big = bi.createGraphics();
        big.setColor(this.color1);
        Polygon2D.Double p = new Polygon2D.Double();
        ((Polygon2D)p).moveTo(0.0, completeSize);
        ((Polygon2D)p).lineTo(mSize, completeSize);
        ((Polygon2D)p).lineTo(0.0, tSize);
        big.fill(p);
        p = new Polygon2D.Double();
        ((Polygon2D)p).moveTo(0.0, mSize);
        ((Polygon2D)p).lineTo(tSize, completeSize);
        ((Polygon2D)p).lineTo(completeSize, completeSize);
        ((Polygon2D)p).lineTo(completeSize, tSize);
        ((Polygon2D)p).lineTo(mSize, 0.0);
        ((Polygon2D)p).lineTo(0.0, 0.0);
        big.fill(p);
        p = new Polygon2D.Double();
        ((Polygon2D)p).moveTo(tSize, 0.0);
        ((Polygon2D)p).lineTo(completeSize, mSize);
        ((Polygon2D)p).lineTo(completeSize, 0.0);
        big.fill(p);
        big.setColor(this.color2);
        p = new Polygon2D.Double();
        ((Polygon2D)p).moveTo(0.0, mSize);
        ((Polygon2D)p).lineTo(0.0, tSize);
        ((Polygon2D)p).lineTo(mSize, completeSize);
        ((Polygon2D)p).lineTo(tSize, completeSize);
        big.fill(p);
        p = new Polygon2D.Double();
        ((Polygon2D)p).moveTo(mSize, 0.0);
        ((Polygon2D)p).lineTo(completeSize, tSize);
        ((Polygon2D)p).lineTo(completeSize, mSize);
        ((Polygon2D)p).lineTo(tSize, 0.0);
        big.fill(p);
        if (fromUpperLeft) {
            AffineTransform affineTransform = AffineTransform.getScaleInstance(-1.0, 1.0);
            affineTransform.translate(-completeSize, 0.0);
            AffineTransformOp op = new AffineTransformOp(affineTransform, 1);
            bi = op.filter(bi, null);
        }
        return new Tripel<BufferedImage, Integer, Integer>(bi, completeSize, completeSize);
    }

    protected Tripel<BufferedImage, Integer, Integer> createVertical(int mSize) {
        int rSize = mSize * 2;
        BufferedImage bi = new BufferedImage(rSize, rSize, 2);
        Graphics2D big = bi.createGraphics();
        big.setBackground(new Color(0, true));
        big.setColor(this.color1);
        big.fillRect(0, 0, mSize, rSize);
        big.setColor(this.color2);
        big.fillRect(mSize, 0, mSize, rSize);
        return new Tripel<BufferedImage, Integer, Integer>(bi, rSize, rSize);
    }

    protected Tripel<BufferedImage, Integer, Integer> createHorizontalImage(int mSize) {
        int rSize = mSize * 2;
        BufferedImage bi = new BufferedImage(rSize, rSize, 2);
        Graphics2D big = bi.createGraphics();
        big.setBackground(new Color(0, true));
        big.clearRect(0, 0, rSize, rSize);
        big.setColor(this.color1);
        big.fillRect(0, 0, rSize, mSize);
        big.setColor(this.color2);
        big.fillRect(0, mSize, rSize, rSize);
        return new Tripel<BufferedImage, Integer, Integer>(bi, rSize, rSize);
    }

    @Override
    protected void resetGraphics(Graphics2D g2d) {
        g2d.setPaint(null);
    }

    @Override
    protected AreaRenderer<? extends RendererProperties, U> emphaziseDefault(U u) {
        return new HatchLineAreaRenderer<U>(PaintUtil.getComplementColor(this.color1), PaintUtil.transform256BaseAlpha(this.color1.getAlpha()), PaintUtil.getComplementColor(this.color2), PaintUtil.transform256BaseAlpha(this.color2.getAlpha()), this.width, this.directionType, null);
    }

    public class HatchLineAreaRendererProperties
    implements RendererProperties {
        private int mSize;
        private double upp;

        @Override
        public void setUpp(double upp) {
            this.upp = upp;
            this.mSize = (int)(HatchLineAreaRenderer.this.width * upp);
            this.mSize = this.mSize < 1 ? 1 : (this.mSize > 100 ? 100 : this.mSize);
        }

        @Override
        public double getUpp() {
            return this.upp;
        }
    }

    public static enum DirectionType {
        HORIZONTAL,
        VERTICAL,
        DIAGONAL_FROM_UPPER_LEFT,
        DIAGONAL_FROM_UPPER_RIGHT;

    }

    public static enum Parameters {
        COLOR_1,
        ALPHA_1,
        COLOR_2,
        ALPHA_2,
        WIDTH,
        DIRECTION_TYPE;

    }
}

