/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing.renderer;

import de.datomino.util.geo.swing.renderer.AbstractLineRenderer;
import de.datomino.util.geo.swing.renderer.DefaultRendererProperties;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Path2D;

public class DashLineRenderer<U>
extends AbstractLineRenderer<RendererProperties, U> {
    private Color color;
    private double width;

    public DashLineRenderer(Color color, double width) {
        this.color = color;
        this.width = width;
    }

    @Override
    public RendererProperties createRendererProperties(U u) {
        return new DefaultRendererProperties();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public Dimension getOptimalPreviewDimension() {
        return new Dimension(30, 10);
    }

    @Override
    protected void render(Graphics2D g2d, U u, Path2D[] paths, RendererProperties rendererProperties) {
        double upp = rendererProperties.getUpp();
        float margin = (float)(upp * this.width);
        Color oColor = g2d.getColor();
        Stroke oStroke = g2d.getStroke();
        g2d.setColor(this.color);
        float f = (float)upp * 15.0f;
        BasicStroke strokeDash = new BasicStroke(margin, 2, 0, 200.0f, new float[]{f}, 100.0f);
        g2d.setStroke(strokeDash);
        for (Path2D path : paths) {
            g2d.draw(path);
        }
        g2d.setColor(oColor);
        g2d.setStroke(oStroke);
    }

    public static enum Parameters {
        COLOR,
        WIDTH;

    }
}

