/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing;

import de.datomino.util.geo.GeomAccess;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.MarkerMode;
import de.datomino.util.geo.swing.AbstractMarkerNavigatorRenderer;
import de.datomino.util.geo.swing.ClickedPolygonMarkerNavigatorRenderer;
import de.datomino.util.geo.swing.DraggedPolygonMarkerNavigatorRenderer;
import de.datomino.util.geo.swing.PaintUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.OnTopRendering;

public abstract class FreeHandMarkerNavigatorRenderer<T extends GeomAccess<ImmutablePolygonKind>>
extends AbstractMarkerNavigatorRenderer {
    private static final long serialVersionUID = -2192322474792778343L;
    public static final Color AREACOLOR = new Color(255, 127, 127, 127);
    private static Color markColor;
    private List<T> polygons;
    private DraggedPolygonMarkerNavigatorRenderer draggedPolygonMarkerNavigatorRenderer = new DraggedPolygonMarkerNavigatorRenderer();
    private ClickedPolygonMarkerNavigatorRenderer clickedPolygonMarkerNavigatorRenderer = new ClickedPolygonMarkerNavigatorRenderer();
    private Float draggedWidthFactor;
    private Float clickedWidthFactor;

    public FreeHandMarkerNavigatorRenderer(String name, NavigatorPanel navigatorPanel, Double maxUpp, String title, List<T> polygons, Float draggedWidthFactor, Float clickedWidthFactor) {
        super(name, navigatorPanel, maxUpp, title);
        this.polygons = polygons;
        this.draggedWidthFactor = draggedWidthFactor;
        this.clickedWidthFactor = clickedWidthFactor;
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        g2d.setColor(FreeHandMarkerNavigatorRenderer.getMarkColor());
        for (GeomAccess immutablePolygon : this.polygons) {
            Area[] areas;
            for (Area area : areas = PaintUtil.createPolygonArea((ImmutablePolygonKind)immutablePolygon.getGeom())) {
                g2d.fill(area);
            }
        }
        switch (this.getMarkerMode()) {
            case FREEHAND_HALF: {
                g2d.setColor(Color.BLUE);
                float widthFactor = this.clickedWidthFactor == null ? super.getWidthFactor() : this.clickedWidthFactor.floatValue();
                this.clickedPolygonMarkerNavigatorRenderer.paintOnto(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp, widthFactor);
                break;
            }
            case FREEHAND_WITHIN: {
                super.paintOnto(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp);
            }
        }
        return Collections.emptyList();
    }

    @Override
    protected void mouseDragFinished(int x, int y, Coordinate startMark, Coordinate endMark, List<Coordinate> tracePoints, MarkerMode markerMode, int modifiers) {
        switch (markerMode) {
            case FREEHAND_WITHIN: {
                Collection<ImmutablePolygonKind> polys = this.draggedPolygonMarkerNavigatorRenderer.mouseDragFinished(startMark, endMark, tracePoints, markerMode, this.getNavigatorPanel());
                for (ImmutablePolygonKind poly : polys) {
                    this.polygons.add(this.createT(poly));
                }
                break;
            }
        }
    }

    @Override
    protected void mouseDragged(int x, int y, Coordinate startMark, Coordinate endMark, List<Coordinate> tracePoints, MarkerMode markerMode, int modifiers) {
        switch (markerMode) {
            default: 
        }
    }

    @Override
    protected void mouseMoved(int x, int y) {
        switch (this.getMarkerMode()) {
            case FREEHAND_HALF: {
                this.clickedPolygonMarkerNavigatorRenderer.mouseMoved(this.createCoordinateForPixel(x, y));
                this.getNavigatorPanel().repaint(1L);
                break;
            }
            case FREEHAND_WITHIN: {
                this.getNavigatorPanel().repaint(1L);
            }
        }
    }

    @Override
    protected void mouseClicked(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
        switch (this.getMarkerMode()) {
            case FREEHAND_WITHIN: {
                super.mouseClicked(x, y, clickCount, modifiers, mouseButton);
                break;
            }
            case FREEHAND_HALF: {
                Collection<ImmutablePolygonKind> polys = this.clickedPolygonMarkerNavigatorRenderer.mouseClicked(this.createCoordinateForPixel(x, y), clickCount, modifiers, mouseButton, this.getNavigatorPanel());
                for (ImmutablePolygonKind poly : polys) {
                    this.polygons.add(this.createT(poly));
                }
                break;
            }
        }
    }

    @Override
    protected void mousePressed(int x, int y, int modifiers, MouseButton mouseButton) {
        switch (this.getMarkerMode()) {
            case FREEHAND_WITHIN: {
                super.mousePressed(x, y, modifiers, mouseButton);
            }
        }
    }

    @Override
    protected float getWidthFactor() {
        if (this.draggedWidthFactor == null) {
            return super.getWidthFactor();
        }
        return this.draggedWidthFactor.floatValue();
    }

    protected abstract T createT(ImmutablePolygonKind var1);

    @Override
    public void close() {
    }

    public static Color getMarkColor() {
        return markColor == null ? AREACOLOR : markColor;
    }

    public static void setMarkColor(Color markColor) {
        FreeHandMarkerNavigatorRenderer.markColor = markColor;
    }

    @Override
    protected Integer getTimerInterval() {
        return 1;
    }
}

