/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing;

import de.datomino.util.geo.GeomAccess;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.swing.AbstractImmutableGeoObjectNavigatorRenderer;
import de.datomino.util.geo.swing.PaintUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.ktde.util.datatypes.Tupel;

public class DefaultImmutableGeoObjectNavigatorRenderer
extends AbstractImmutableGeoObjectNavigatorRenderer<ImmutableGeoObject> {
    public Map<GeomAccess<? extends ImmutableGeoObject>, Integer> colorMap = new IdentityHashMap<GeomAccess<? extends ImmutableGeoObject>, Integer>();

    public DefaultImmutableGeoObjectNavigatorRenderer(String name) {
        super(name);
    }

    @Override
    public final void add(GeomAccess<? extends ImmutableGeoObject> e) {
        this.add(e, 0);
    }

    public void add(GeomAccess<? extends ImmutableGeoObject> e, int color) {
        this.colorMap.put(e, color);
        super.add(e);
    }

    @Override
    public final void addAll(Collection<? extends GeomAccess<? extends ImmutableGeoObject>> geoms) {
        for (GeomAccess<? extends ImmutableGeoObject> geomAccess : geoms) {
            this.add(geomAccess);
        }
    }

    public final void addAll(Collection<? extends GeomAccess<? extends ImmutableGeoObject>> geoms, int color) {
        for (GeomAccess<? extends ImmutableGeoObject> geomAccess : geoms) {
            this.add(geomAccess, color);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.colorMap.clear();
    }

    @Override
    protected Tupel<Color, Color> getColor(GeomAccess<? extends ImmutableGeoObject> geom) {
        if (geom == null || this.colorMap.get(geom) == null) {
            return null;
        }
        int defsize = PaintUtil.DEFCOLORS.size();
        return PaintUtil.DEFCOLORS.get(this.colorMap.get(geom) % defsize);
    }
}

