/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing;

import de.datomino.util.geo.MarkerMode;
import de.datomino.util.geo.swing.AbstractEnhancedMouseManipulatorAction;
import de.datomino.util.geo.swing.ObjectMarkerSwitchModeAction;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ktde.math.helper.ComputeTrigonometrics;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorPanningAction;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.swing.navigator.listener.NavigatorRendererActivateEvent;
import org.ktde.swing.navigator.listener.NavigatorRendererActiveListener;

public abstract class AbstractMarkerNavigatorRenderer
extends AbstractEnhancedMouseManipulatorAction
implements NavigatorRenderer {
    private static final long serialVersionUID = -7741840789913071092L;
    public static final Color AREACOLOR = new Color(255, 127, 127, 127);
    private Coordinate startMark;
    private Coordinate endMark;
    private List<Coordinate> tracePoints;
    private MarkerMode markerMode;
    private int modifiers;
    private boolean showTrace;
    private Set<ObjectMarkerSwitchModeAction> objectMarkerSwitchModeActions;
    private List<NavigatorRendererActiveListener> navigatorPanelActiveListeners = new ArrayList<NavigatorRendererActiveListener>();
    private String name;
    private int sortOrder = Integer.MAX_VALUE;

    public AbstractMarkerNavigatorRenderer(String name, NavigatorPanel navigatorPanel, Double maxUpp, String title) {
        super(navigatorPanel, maxUpp, title);
        this.name = name;
        this.startMark = null;
        this.endMark = null;
        this.markerMode = MarkerMode.RECTANGLE_WITHIN;
        this.objectMarkerSwitchModeActions = new HashSet<ObjectMarkerSwitchModeAction>();
        this.showTrace = false;
        this.tracePoints = null;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        NavigatorPanningAction.performWheelZoom(e, this.getNavigatorPanel());
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        if (this.startMark != null && this.endMark != null) {
            BasicStroke stroke = new BasicStroke((float)(upp * (double)this.getWidthFactor()));
            g2d.setStroke(stroke);
            g2d.setColor(Color.BLUE);
            Coordinate pointTL = this.getNavigatorPanel().getCoordinateFactory().createCoordinate(this.startMark);
            Coordinate pointBR = this.getNavigatorPanel().getCoordinateFactory().createCoordinate(this.endMark);
            RectangularShape rectMark = null;
            String mouseText = null;
            switch (this.markerMode) {
                case RECTANGLE_WITHIN: 
                case RECTANGLE_CROSSES: {
                    double rLeft = Math.min(pointTL.getX(), pointBR.getX());
                    double rBottom = Math.min(pointTL.getY(), pointBR.getY());
                    double rWidth = Math.abs(pointTL.getX() - pointBR.getX());
                    double rHeight = Math.abs(pointTL.getY() - pointBR.getY());
                    rectMark = new Rectangle2D.Double(rLeft, rBottom, rWidth, rHeight);
                    break;
                }
                case CIRCLE_CROSSES: 
                case CIRCLE_WITHIN: {
                    double dist = Math.sqrt(Math.pow(pointTL.getX() - pointBR.getX(), 2.0) + Math.pow(pointTL.getY() - pointBR.getY(), 2.0));
                    rectMark = new Ellipse2D.Double(pointTL.getX() - dist, pointTL.getY() - dist, 2.0 * dist, 2.0 * dist);
                    double realDist = ComputeTrigonometrics.getSphericalDistance(pointTL, pointBR);
                    DecimalFormat decimalFormat = new DecimalFormat("#.#");
                    mouseText = decimalFormat.format(realDist / 500.0) + " km";
                    break;
                }
            }
            if (rectMark != null) {
                g2d.draw(rectMark);
                if (mouseText != null) {
                    AffineTransform affineTransform = g2d.getTransform();
                    double scaleX = affineTransform.getScaleX() / 1.5;
                    double scaleY = affineTransform.getScaleY() / 1.5;
                    AffineTransform flip = AffineTransform.getScaleInstance(1.0 / scaleX, 1.0 / scaleY);
                    g2d.transform(flip);
                    Point2D.Double dst = new Point2D.Double();
                    AffineTransform.getScaleInstance(scaleX, scaleY).transform(new Point2D.Double(pointBR.getX() + 15.0 * upp, pointBR.getY() - 20.0 * upp), dst);
                    g2d.drawString(mouseText, (float)dst.getX(), (float)dst.getY());
                    g2d.setTransform(affineTransform);
                }
            }
            if (this.showTrace) {
                boolean first = true;
                GeneralPath line = new GeneralPath();
                for (Coordinate point : this.tracePoints) {
                    Coordinate c = this.getNavigatorPanel().getCoordinateFactory().createCoordinate(point);
                    if (first) {
                        ((Path2D)line).moveTo(c.getX(), c.getY());
                        first = false;
                        continue;
                    }
                    ((Path2D)line).lineTo(c.getX(), c.getY());
                }
                g2d.draw(line);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
    }

    @Override
    protected void turnedOn() {
        for (ObjectMarkerSwitchModeAction objectMarkerSwitchModeAction : this.objectMarkerSwitchModeActions) {
            objectMarkerSwitchModeAction.setEnabled(true);
        }
    }

    @Override
    protected void turnedOff() {
        for (ObjectMarkerSwitchModeAction objectMarkerSwitchModeAction : this.objectMarkerSwitchModeActions) {
            objectMarkerSwitchModeAction.setEnabled(false);
        }
    }

    @Override
    protected void mousePressed(int x, int y, int modifiers, MouseButton mouseButton) {
        this.startMark = this.createCoordinateForPixel(x, y);
        this.modifiers = modifiers;
        this.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
        if (this.tracePoints != null) {
            this.tracePoints.clear();
        }
    }

    @Override
    protected void mouseDragged(int x, int y) {
        this.endMark = this.createCoordinateForPixel(x, y);
        if (this.showTrace) {
            if (this.tracePoints.isEmpty()) {
                this.tracePoints.add(this.startMark);
            }
            this.tracePoints.add(this.endMark);
        }
        this.mouseDragged(x, y, this.startMark, this.endMark, this.tracePoints, this.markerMode, this.modifiers);
        this.getNavigatorPanel().repaint(10L);
    }

    @Override
    protected void mouseDragFinished(int x, int y, int modifiers) {
        this.mouseDragFinished(x, y, this.startMark, this.endMark, this.tracePoints, this.markerMode, this.modifiers);
        this.startMark = null;
        this.endMark = null;
        if (this.tracePoints != null) {
            this.tracePoints.clear();
        }
        this.getNavigatorPanel().repaint(10L);
    }

    @Override
    protected void mouseClicked(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
        this.startMark = null;
        this.endMark = null;
    }

    @Override
    protected void mouseMoved(int x, int y) {
    }

    public void setMarkerMode(MarkerMode markerMode) {
        this.markerMode = markerMode;
        switch (this.markerMode) {
            case FREEHAND_WITHIN: 
            case FREEHAND_HALF: {
                this.showTrace = true;
                this.tracePoints = new ArrayList<Coordinate>();
                break;
            }
            default: {
                this.showTrace = false;
                this.tracePoints = null;
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void addAllowedMarkMode(ObjectMarkerSwitchModeAction objectMarkerSwitchModeAction) {
        this.objectMarkerSwitchModeActions.add(objectMarkerSwitchModeAction);
    }

    protected MarkerMode getMarkerMode() {
        return this.markerMode;
    }

    protected float getWidthFactor() {
        return 1.0f;
    }

    protected abstract void mouseDragFinished(int var1, int var2, Coordinate var3, Coordinate var4, List<Coordinate> var5, MarkerMode var6, int var7);

    protected abstract void mouseDragged(int var1, int var2, Coordinate var3, Coordinate var4, List<Coordinate> var5, MarkerMode var6, int var7);

    @Override
    public void addNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.add(navigatorPanelActiveListener);
    }

    @Override
    public void removeNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.remove(navigatorPanelActiveListener);
    }

    protected void fireActiveChanged() {
        NavigatorRendererActivateEvent navigatorPanelActivateEvent = new NavigatorRendererActivateEvent(this, this.isActive());
        for (NavigatorRendererActiveListener navigatorPanelActiveListener : this.navigatorPanelActiveListeners) {
            navigatorPanelActiveListener.valueChanged(navigatorPanelActivateEvent);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }
}

