/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing;

import de.datomino.util.geo.GeomAccess;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutableMultiLineString;
import de.datomino.util.geo.ImmutableMultiPolygon;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.swing.PaintUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.AbstractNavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractImmutableGeoObjectNavigatorRenderer<T extends ImmutableGeoObject>
extends AbstractNavigatorRenderer {
    private static final Tupel<Color, Color> DEFAULT_COLOR = new Tupel<Color, Color>(Color.BLACK, Color.BLACK);
    private double maxUpp;
    private double minUpp;
    private boolean visible;
    private LinkedList<GeomAccess<? extends T>> geometries;

    public AbstractImmutableGeoObjectNavigatorRenderer(String name) {
        this(name, 0.0, Double.MAX_VALUE);
    }

    public AbstractImmutableGeoObjectNavigatorRenderer(String name, double maxUpp) {
        this(name, 0.0, maxUpp);
    }

    public AbstractImmutableGeoObjectNavigatorRenderer(String name, double minUpp, double maxUpp) {
        super(name);
        this.maxUpp = maxUpp;
        this.minUpp = minUpp;
        this.visible = true;
        this.geometries = new LinkedList();
    }

    public void setVisible(boolean b) {
        if (this.visible != b) {
            this.visible = b;
            this.callRepaint();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public double getMaxUpp() {
        return this.maxUpp;
    }

    public void setMaxUpp(double maxUpp) {
        this.maxUpp = maxUpp;
        this.callRepaint();
    }

    public double getMinUpp() {
        return this.minUpp;
    }

    public void setMinUpp(double minUpp) {
        this.minUpp = minUpp;
        this.callRepaint();
    }

    public void render(ImmutableGeoObject geom, Tupel<Color, Color> color, Graphics2D g2d, double upp) {
        if (color != null && geom != null) {
            double size = this.getSize(geom);
            double margin = size * upp;
            if (geom instanceof ImmutablePoint) {
                this.drawPoint(g2d, (ImmutablePoint)geom, upp, size, margin, color);
            } else if (geom instanceof ImmutableLineString) {
                this.drawLineString(g2d, (ImmutableLineString)geom, upp, size, margin, color);
            } else if (geom instanceof ImmutablePolygon) {
                this.drawPolygon(g2d, (ImmutablePolygon)geom, upp, size, margin, color);
            } else if (geom instanceof ImmutableMultiPolygon) {
                this.drawMultiPolygon(g2d, (ImmutableMultiPolygon)geom, upp, size, margin, color);
            } else if (geom instanceof ImmutableMultiLineString) {
                this.drawMultiLineString(g2d, (ImmutableMultiLineString)geom, upp, size, margin, color);
            } else {
                throw new IllegalArgumentException("Not supported geoObject: " + geom);
            }
        }
    }

    protected double getSize(ImmutableGeoObject geom) {
        return 5.0;
    }

    protected Tupel<Color, Color> getColor(GeomAccess<? extends T> geom) {
        return DEFAULT_COLOR;
    }

    protected void drawMultiPolygon(Graphics2D g2d, ImmutableMultiPolygon geom, double upp, double size, double margin, Tupel<Color, Color> color) {
        for (ImmutablePolygon immutablePolygon : geom.getParts()) {
            this.drawPolygon(g2d, immutablePolygon, upp, size, margin, color);
        }
    }

    public void drawPolygon(Graphics2D g2d, ImmutablePolygon geom, double upp, double size, double margin, Tupel<Color, Color> color) {
        AbstractImmutableGeoObjectNavigatorRenderer.drawPolgonArea(g2d, geom, margin, color);
        this.drawLineString(g2d, geom.getShell(), upp, size, margin, color);
        for (ImmutableLineString lineStringA : geom.getHoles()) {
            this.drawLineString(g2d, lineStringA, upp, size, margin, color);
        }
    }

    public static void drawPolgonArea(Graphics2D g2d, ImmutablePolygon geom, double margin, Tupel<Color, Color> color) {
        Area polyarea = PaintUtil.createPolygonArea(geom);
        int si1 = (int)(6.0 * margin);
        TexturePaint tp = null;
        if (si1 > 1000) {
            int r = (color.getElement1().getRed() + color.getElement2().getRed()) / 2;
            int g = (color.getElement1().getGreen() + color.getElement2().getGreen()) / 2;
            int b = (color.getElement1().getBlue() + color.getElement2().getBlue()) / 2;
            int argb = r << 16 | g << 8 | b | 0x77000000;
            g2d.setColor(new Color(argb, true));
        } else {
            si1 = si1 < 1 ? 1 : (si1 > 100 ? 100 : si1);
            int si2 = si1 * 2;
            BufferedImage bi = new BufferedImage(si2, si2, 2);
            Graphics2D big = bi.createGraphics();
            big.setBackground(new Color(0, true));
            big.clearRect(0, 0, si2, si2);
            big.setColor(new Color(color.getElement1().getRGB() & 0x77FFFFFF, true));
            big.fillRect(0, si1, si1, si1);
            big.fillRect(si1, 0, si1, si1);
            big.setColor(new Color(color.getElement2().getRGB() & 0x77FFFFFF, true));
            big.fillRect(0, 0, si1, si1);
            big.fillRect(si1, si1, si1, si1);
            Rectangle r = new Rectangle(0, 0, si2, si2);
            tp = new TexturePaint(bi, r);
        }
        g2d.setPaint(tp);
        g2d.fill(polyarea);
        g2d.setPaint(null);
    }

    protected void drawMultiLineString(Graphics2D g2d, ImmutableMultiLineString geom, double upp, double size, double margin, Tupel<Color, Color> color) {
        for (ImmutableLineString immutableLineString : geom.getParts()) {
            this.drawLineString(g2d, immutableLineString, upp, size, margin, color);
        }
    }

    protected void drawLineString(Graphics2D g2d, ImmutableLineString geom, double upp, double size, double margin, Tupel<Color, Color> color) {
        Color color1 = color.getElement1();
        Color color2 = color.getElement2();
        boolean first = true;
        Line2D.Double line = new Line2D.Double();
        g2d.setColor(color1);
        Stroke stroke = this.getLinestringStroke(margin);
        BasicStroke strokeDash = null;
        if (!color1.equals(color2)) {
            strokeDash = new BasicStroke((float)margin, 2, 0, 10.0f, new float[]{15.0f, 15.0f}, 0.0f);
        }
        g2d.setStroke(stroke);
        for (ImmutablePoint immutablePoint : geom.getCoordinates()) {
            line.x1 = line.x2;
            line.y1 = line.y2;
            Coordinate c = immutablePoint.getCoordinate();
            line.x2 = c.getX();
            line.y2 = c.getY();
            if (first) {
                first = false;
                continue;
            }
            g2d.draw(line);
            if (color1.equals(color2)) continue;
            g2d.setColor(color2);
            g2d.setStroke(strokeDash);
            g2d.draw(line);
            g2d.setColor(color1);
            g2d.setStroke(stroke);
        }
    }

    protected Stroke getLinestringStroke(double margin) {
        return new BasicStroke((float)margin);
    }

    protected void drawPoint(Graphics2D g2d, ImmutablePoint geom, double upp, double size, double margin, Tupel<Color, Color> color) {
        if (color != null) {
            Color color1 = color.getElement1();
            Color color2 = color.getElement2();
            g2d.setColor(color1);
            Ellipse2D.Double ellipse = new Ellipse2D.Double();
            Coordinate c = geom.getCoordinate();
            ellipse.x = c.getX() - margin;
            ellipse.y = c.getY() - margin;
            ellipse.width = 2.0 * margin;
            ellipse.height = 2.0 * margin;
            g2d.fill(ellipse);
            g2d.setColor(color2);
            BasicStroke stroke = new BasicStroke((float)(margin * 0.8));
            g2d.setStroke(stroke);
            g2d.draw(ellipse);
        }
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        if (!this.isVisible() || upp > this.getMaxUpp() || upp < this.getMinUpp()) {
            return Collections.emptyList();
        }
        CoordinateFactory factory = this.getPanel().getCoordinateFactory();
        ArrayList<GeomAccess<T>> geomClone = new ArrayList<GeomAccess<T>>(this.geometries);
        for (GeomAccess geomAccess : geomClone) {
            this.callRender(g2d, upp, factory, geomAccess);
        }
        return Collections.emptyList();
    }

    protected void callRender(Graphics2D g2d, double upp, CoordinateFactory factory, GeomAccess<? extends T> geom) {
        Tupel<Color, Color> color = this.getColor(geom);
        this.render(geom.getGeom().getTransformed(factory), color, g2d, upp);
    }

    public void add(GeomAccess<? extends T> e) {
        this.geometries.add(e);
        this.callRepaint();
    }

    public void addAll(Collection<? extends GeomAccess<? extends T>> geoms) {
        this.geometries.addAll(geoms);
        this.callRepaint();
    }

    public void clear() {
        this.geometries.clear();
        this.callRepaint();
    }
}

