/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.model.time;

import de.datomino.util.ValueChangeObservable;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.exception.IllegalPointCountException;
import de.datomino.util.geo.model.AbstractGeoObjectBucketsModel;
import de.datomino.util.geo.model.BucketsFetchCallback;
import de.datomino.util.geo.model.FetchingGeoObjectBucketsModel;
import de.datomino.util.geo.model.GeoObjectBucketsChangedEvent;
import de.datomino.util.geo.model.GeomExtractor;
import de.datomino.util.geo.model.time.TimeBasedBucketsFetchCallback;
import de.datomino.util.geo.model.time.TimeRange;
import de.datomino.util.geo.model.time.TimeRangeList;
import de.datomino.util.math.MathUtil;
import de.datomino.util.swing.blocking.BusyHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;
import org.ktde.util.datatypes.Tupel;

public class TimeBasedGeoObjectBucketsModel<S extends ValueChangeObservable, T extends ImmutableGeoObject>
extends AbstractGeoObjectBucketsModel<S, T>
implements ValueChangeListener,
FetchingGeoObjectBucketsModel<S, T> {
    private Map<Tupel<Integer, Integer>, Tupel<Set<S>, TimeRangeList>> bucketGeoObjects = new HashMap<Tupel<Integer, Integer>, Tupel<Set<S>, TimeRangeList>>();
    private double bucketDimension;
    private TimeBasedBucketsFetchCallback<S, T> callback;
    private TimeRange currentTimeRange;

    public TimeBasedGeoObjectBucketsModel(CoordinateFactory coordinateFactory, GeomExtractor<S, T> geomExtractor) {
        this(1000.0 * coordinateFactory.getRefScale(), coordinateFactory, geomExtractor);
    }

    public TimeBasedGeoObjectBucketsModel(double bucketDimension, CoordinateFactory coordinateFactory, GeomExtractor<S, T> geomExtractor) {
        this(bucketDimension, coordinateFactory, geomExtractor, null);
    }

    public TimeBasedGeoObjectBucketsModel(double bucketDimension, CoordinateFactory coordinateFactory, GeomExtractor<S, T> geomExtractor, ImmutablePolygon maxEnvelope) {
        super(geomExtractor, coordinateFactory, maxEnvelope);
        this.bucketDimension = bucketDimension * coordinateFactory.getRefScale();
    }

    @Override
    public boolean contains(S model) {
        for (Tupel<Set<S>, TimeRangeList> tupel : this.bucketGeoObjects.values()) {
            Set<S> set = tupel.getElement1();
            if (!set.contains(model)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setBusyHandler(BusyHandler busyHandler) {
    }

    @Override
    public void setFetchCallback(TimeBasedBucketsFetchCallback<S, T> callback) {
        this.callback = callback;
    }

    @Override
    public void setFetchCallback(BucketsFetchCallback<S, T> callback) {
        throw new RuntimeException("not supported");
    }

    @Override
    public void addGeom(S model) {
        this.addGeomInternal(model);
        this.fireGeoObjectBucketsChangedEvent(new GeoObjectBucketsChangedEvent(this));
    }

    @Override
    public void addAll(Collection<? extends S> models) {
        for (ValueChangeObservable model : models) {
            this.addGeomInternal(model);
        }
        this.fireGeoObjectBucketsChangedEvent(new GeoObjectBucketsChangedEvent(this));
    }

    public Set<S> getAllLoadedElements() {
        HashSet<S> all = new HashSet<S>();
        for (Tupel<Set<S>, TimeRangeList> tupel : this.bucketGeoObjects.values()) {
            Set<S> sub = tupel.getElement1();
            if (sub == null) continue;
            all.addAll(sub);
        }
        return all;
    }

    public boolean isEmpty() {
        for (Tupel<Set<S>, TimeRangeList> tupel : this.bucketGeoObjects.values()) {
            if (tupel.getElement1().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Set<S> findBottomLeftBucket(boolean empty) {
        Tupel<Integer, Integer> bottomLeft = null;
        for (Tupel<Integer, Integer> tupel : this.bucketGeoObjects.keySet()) {
            Integer sum = MathUtil.sum(tupel.getElement1(), tupel.getElement2());
            if (bottomLeft != null && sum.compareTo(MathUtil.sum(bottomLeft.getElement1(), bottomLeft.getElement2())) >= 0 || !empty && this.bucketGeoObjects.get(tupel).getElement1().isEmpty()) continue;
            bottomLeft = tupel;
        }
        return this.bucketGeoObjects.get(bottomLeft).getElement1();
    }

    public Set<S> findBottomRightBucket(boolean empty) {
        Tupel<Integer, Integer> bottomRight = null;
        for (Tupel<Integer, Integer> tupel : this.bucketGeoObjects.keySet()) {
            Integer sub = MathUtil.sub(tupel.getElement1(), tupel.getElement2());
            if (bottomRight != null && sub.compareTo(MathUtil.sub((Integer)bottomRight.getElement1(), bottomRight.getElement2())) <= 0 || !empty && this.bucketGeoObjects.get(tupel).getElement1().isEmpty()) continue;
            bottomRight = tupel;
        }
        return this.bucketGeoObjects.get(bottomRight).getElement1();
    }

    public Set<S> findTopLeftBucket(boolean empty) {
        Tupel<Integer, Integer> topLeft = null;
        for (Tupel<Integer, Integer> tupel : this.bucketGeoObjects.keySet()) {
            Integer sub = MathUtil.sub(tupel.getElement2(), tupel.getElement1());
            if (topLeft != null && sub.compareTo(MathUtil.sum(topLeft.getElement2(), topLeft.getElement1())) <= 0 || !empty && this.bucketGeoObjects.get(tupel).getElement1().isEmpty()) continue;
            topLeft = tupel;
        }
        return this.bucketGeoObjects.get(topLeft).getElement1();
    }

    public Set<S> findTopRightBucket(boolean empty) {
        Tupel<Integer, Integer> topRight = null;
        for (Tupel<Integer, Integer> tupel : this.bucketGeoObjects.keySet()) {
            Integer sum = MathUtil.sum(tupel.getElement1(), tupel.getElement2());
            if (topRight != null && sum.compareTo(MathUtil.sum(topRight.getElement1(), topRight.getElement2())) <= 0 || !empty && this.bucketGeoObjects.get(tupel).getElement1().isEmpty()) continue;
            topRight = tupel;
        }
        return this.bucketGeoObjects.get(topRight).getElement1();
    }

    private void addGeomInternal(S model) {
        Object geom = this.getGeomExtractor().getGeom(model);
        if (geom != null) {
            model.removeValueChangeListener(this);
            model.addValueChangeListener(this);
            ImmutableGeoObject transformed = geom.getTransformed(this.getCoordinateFactory());
            int startX = (int)Math.floor(transformed.getMinX() / this.bucketDimension);
            int endX = (int)Math.floor(transformed.getMaxX() / this.bucketDimension);
            int startY = (int)Math.floor(transformed.getMinY() / this.bucketDimension);
            int endY = (int)Math.floor(transformed.getMaxY() / this.bucketDimension);
            for (int i = startX; i <= endX; ++i) {
                for (int j = startY; j <= endY; ++j) {
                    if (!this.isInBucket(transformed, i, j)) continue;
                    Tupel<Integer, Integer> tupel = new Tupel<Integer, Integer>(i, j);
                    Tupel<Set<S>, TimeRangeList> tupel2 = this.bucketGeoObjects.get(tupel);
                    if (tupel2 == null) {
                        tupel2 = new Tupel(new HashSet(), new TimeRangeList());
                        this.bucketGeoObjects.put(tupel, tupel2);
                    }
                    tupel2.getElement1().add(model);
                }
            }
        }
    }

    private boolean isInBucket(ImmutableGeoObject t, int i, int j) {
        double left = (double)i * this.bucketDimension;
        double bottom = (double)j * this.bucketDimension;
        double right = (double)(i + 1) * this.bucketDimension;
        double top = (double)(j + 1) * this.bucketDimension;
        ArrayList<Coordinate> points = new ArrayList<Coordinate>(4);
        points.add(this.getCoordinateFactory().createCoordinate(left, bottom));
        points.add(this.getCoordinateFactory().createCoordinate(right, bottom));
        points.add(this.getCoordinateFactory().createCoordinate(right, top));
        points.add(this.getCoordinateFactory().createCoordinate(left, top));
        List<List<Coordinate>> emptyList = Collections.emptyList();
        try {
            ImmutablePolygon polygon = ImmutableGeoObjectFactory.createImmutablePolygonByCoordinates(points, emptyList);
            boolean b = polygon.contains(t) || polygon.intersects(t) || t.contains(polygon);
            return b;
        }
        catch (IllegalPointCountException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clear() {
        this.bucketGeoObjects.clear();
        this.fireGeoObjectBucketsChangedEvent(new GeoObjectBucketsChangedEvent(this));
    }

    @Override
    public void remove(S model) {
        this.removeInternal(model);
        this.fireGeoObjectBucketsChangedEvent(new GeoObjectBucketsChangedEvent(this));
    }

    private boolean removeInternal(S model) {
        boolean found = false;
        HashSet<Tupel<Set<S>, TimeRangeList>> emptyTupels = new HashSet<Tupel<Set<S>, TimeRangeList>>();
        for (Tupel<Set<S>, TimeRangeList> tupel : this.bucketGeoObjects.values()) {
            Set<S> set = tupel.getElement1();
            found |= set.remove(model);
            if (!set.isEmpty()) continue;
            emptyTupels.add(tupel);
        }
        for (Tupel<Set<S>, TimeRangeList> empty : emptyTupels) {
            this.bucketGeoObjects.remove(empty);
        }
        return found;
    }

    @Override
    public void valueChanged(ValueChangeEvent e) {
        ValueChangeObservable source = (ValueChangeObservable)e.getSource();
        ValueChangeEvent.Type type = e.getType();
        boolean fire = false;
        switch (type) {
            case DELETE: {
                this.removeInternal(source);
                fire = true;
                break;
            }
            case UPDATE: {
                if (!(e.getOldValue() instanceof ImmutableGeoObject) && !(e.getNewValue() instanceof ImmutableGeoObject)) break;
                this.removeInternal(source);
                this.addGeomInternal(source);
                fire = true;
                break;
            }
            case UNDELETE: {
                this.addGeom(source);
                fire = true;
                break;
            }
        }
        if (fire) {
            this.fireGeoObjectBucketsChangedEvent(new GeoObjectBucketsChangedEvent(this));
        }
    }

    @Override
    protected synchronized Collection<Collection<S>> findBuckets(double minx0, double maxx0, double maxy0, double miny0) {
        int startX = (int)Math.floor(minx0 / this.bucketDimension);
        int endX = (int)Math.floor(maxx0 / this.bucketDimension);
        int startY = (int)Math.floor(miny0 / this.bucketDimension);
        int endY = (int)Math.floor(maxy0 / this.bucketDimension);
        ArrayList<Collection<S>> buckets = new ArrayList<Collection<S>>((endX - startX + 1) * (endY - startY + 1));
        for (int i = startX; i <= endX; ++i) {
            for (int j = startY; j <= endY; ++j) {
                Tupel<Integer, Integer> key = new Tupel<Integer, Integer>(i, j);
                Tupel<Set<S>, TimeRangeList> values = this.bucketGeoObjects.get(key);
                if (values == null || !values.getElement2().coversTimeRange(this.currentTimeRange)) {
                    Collection<S> models = this.fetchBucket(i, j, this.currentTimeRange);
                    for (ValueChangeObservable model : models) {
                        model.removeValueChangeListener(this);
                        model.addValueChangeListener(this);
                    }
                    if (values == null) {
                        TimeRangeList timeRange = this.currentTimeRange == null ? new TimeRangeList() : new TimeRangeList(this.currentTimeRange);
                        values = new Tupel<HashSet<Set<S>>, TimeRangeList>(new HashSet<S>(models), timeRange);
                        this.bucketGeoObjects.put(key, values);
                    } else {
                        values.getElement1().addAll(models);
                        values.setElement2(values.getElement2().addTimeRange(this.currentTimeRange));
                    }
                }
                buckets.add(values.getElement1());
            }
        }
        return buckets;
    }

    private Collection<S> fetchBucket(int i, int j, TimeRange timeRange) {
        if (timeRange == null) {
            return Collections.emptyList();
        }
        Coordinate topLeft = this.getCoordinateFactory().createCoordinate((double)i * this.bucketDimension, (double)(j + 1) * this.bucketDimension);
        Coordinate bottomRight = this.getCoordinateFactory().createCoordinate((double)(i + 1) * this.bucketDimension, (double)j * this.bucketDimension);
        return this.callback.fetch(topLeft, bottomRight, timeRange.getStart(), timeRange.getEnd());
    }

    public int getSize() {
        int size = 0;
        for (Tupel<Set<S>, TimeRangeList> tupel : this.bucketGeoObjects.values()) {
            Set<S> sub = tupel.getElement1();
            if (sub == null) continue;
            size += sub.size();
        }
        return size;
    }

    public void setCurrentTimeRange(TimeRange currentTimeRange) {
        this.currentTimeRange = currentTimeRange;
    }
}

