/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.exception;

import de.datomino.util.geo.GeomAccess;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.swing.AbstractImmutableGeoObjectNavigatorRenderer;
import de.datomino.util.geo.swing.PaintUtil;
import de.datomino.util.geo.util.GeoTypeHelper;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.datatypes.Tupel;

public class GeometryDebugException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private Collection<? extends ImmutableGeoObject> geom;

    public GeometryDebugException(Object ... geom) {
        this("Debug Geom", GeoTypeHelper.getGeoObjects(geom));
    }

    public GeometryDebugException(Collection<?> geom) {
        this("Debug Geom", GeoTypeHelper.getGeoObjects(geom));
    }

    public GeometryDebugException(String message, Collection<?> geom) {
        this(message, GeoTypeHelper.getGeoObjects(geom), true);
    }

    private GeometryDebugException(String message, Collection<ImmutableGeoObject> geom, boolean flag) {
        super(message);
        this.geom = geom;
    }

    public GeometryDebugException(Collection<? extends ImmutableGeoObject> geom, String message) {
        super(message);
        this.geom = geom;
    }

    public NavigatorRenderer getGeomRenderer() {
        GeomRenderer renderer = new GeomRenderer("GeometryDebugException");
        Collection<? extends ImmutableGeoObject> cgeom = this.geom;
        renderer.addAll(cgeom);
        return renderer;
    }

    public Collection<? extends ImmutableGeoObject> getGeom() {
        return this.geom;
    }

    private class GeomRenderer
    extends AbstractImmutableGeoObjectNavigatorRenderer<ImmutableGeoObject> {
        private int colornumber;

        public GeomRenderer(String name) {
            super(name);
            this.colornumber = 0;
        }

        @Override
        public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
            this.colornumber = 0;
            return super.paintOnto(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp);
        }

        @Override
        public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        }

        @Override
        protected Tupel<Color, Color> getColor(GeomAccess<? extends ImmutableGeoObject> geom) {
            int defsize = PaintUtil.DEFCOLORS.size();
            return PaintUtil.DEFCOLORS.get(this.colornumber++ % defsize);
        }
    }
}

