/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.dto;

import com.vividsolutions.jts.io.WKTReader;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.ktde.math.projection.CoordinateFactory;

public abstract class AbstractImmutableGeoObjectDto<T extends ImmutableGeoObject>
implements Serializable {
    private static final long serialVersionUID = 5518620453792674850L;

    protected abstract void setBytes(String var1);

    protected abstract String getBytes();

    protected abstract void setCoordinateFactoryName(String var1);

    protected abstract String getCoordinateFactoryName();

    protected AbstractImmutableGeoObjectDto(ImmutableGeoObject t) {
        if (t != null) {
            this.setBytes(t.getWkt());
            if (this.getBytes() == null) {
                this.setBytes("");
            }
            this.setCoordinateFactoryName(t.getCoordinateFactory().getName());
        } else {
            this.setBytes("");
            this.setCoordinateFactoryName("");
        }
    }

    public T getGeoObject() {
        if (this.getBytes() == null || this.getBytes().isEmpty()) {
            return null;
        }
        try {
            return (T)ImmutableGeoObjectFactory.createImmutableGeoObject(new WKTReader().read(this.getBytes()), CoordinateFactory.getInstance(this.getCoordinateFactoryName()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractImmutableGeoObjectDto) {
            AbstractImmutableGeoObjectDto other = (AbstractImmutableGeoObjectDto)obj;
            return new EqualsBuilder().append(other.getBytes(), this.getBytes()).append(other.getCoordinateFactoryName(), this.getCoordinateFactoryName()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getBytes()).append(this.getCoordinateFactoryName()).toHashCode();
    }
}

