/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo;

import de.datomino.util.geo.GeomModel;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.ktde.math.helper.ComputeTrigonometrics;

public class LinestringHolderAtPointComparator
implements Comparator<GeomModel<ImmutableLineString>> {
    private ImmutablePoint point;

    public LinestringHolderAtPointComparator(ImmutablePoint point) {
        this.point = point;
    }

    @Override
    public int compare(GeomModel<ImmutableLineString> arg1, GeomModel<ImmutableLineString> arg2) {
        List<ImmutablePoint> coords1 = ((ImmutableLineString)arg1.getGeom()).getCoordinates();
        List<ImmutablePoint> coords2 = ((ImmutableLineString)arg2.getGeom()).getCoordinates();
        if (!coords1.get(0).equals(this.point)) {
            coords1 = new ArrayList<ImmutablePoint>(coords1);
            Collections.reverse(coords1);
        }
        if (!coords2.get(0).equals(this.point)) {
            coords2 = new ArrayList<ImmutablePoint>(coords2);
            Collections.reverse(coords2);
        }
        double xs = coords1.get(0).getX();
        double ys = coords1.get(0).getY();
        double x1 = coords1.get(1).getX();
        double y1 = coords1.get(1).getY();
        double x2 = coords2.get(1).getX();
        double y2 = coords2.get(1).getY();
        double angle1 = ComputeTrigonometrics.normalizeAngle(xs, ys, x1, y1);
        double angle2 = ComputeTrigonometrics.normalizeAngle(xs, ys, x2, y2);
        return Double.valueOf(angle1).compareTo(angle2);
    }
}

