/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo;

import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.ktde.math.helper.ComputeTrigonometrics;

public class LinestringAtPointComparator
implements Comparator<ImmutableLineString> {
    private ImmutablePoint point;

    public LinestringAtPointComparator(ImmutablePoint point) {
        this.point = point;
    }

    @Override
    public int compare(ImmutableLineString arg1, ImmutableLineString arg2) {
        List<ImmutablePoint> coords1 = arg1.getCoordinates();
        List<ImmutablePoint> coords2 = arg2.getCoordinates();
        if (!coords1.get(0).equals(this.point)) {
            coords1 = new ArrayList<ImmutablePoint>(coords1);
            Collections.reverse(coords1);
        }
        if (!coords2.get(0).equals(this.point)) {
            coords2 = new ArrayList<ImmutablePoint>(coords2);
            Collections.reverse(coords2);
        }
        double xs = coords1.get(0).getX();
        double ys = coords1.get(0).getY();
        double x1 = coords1.get(1).getX();
        double y1 = coords1.get(1).getY();
        double x2 = coords2.get(1).getX();
        double y2 = coords2.get(1).getY();
        double angle1 = ComputeTrigonometrics.normalizeAngle(xs, ys, x1, y1);
        double angle2 = ComputeTrigonometrics.normalizeAngle(xs, ys, x2, y2);
        return Double.valueOf(angle1).compareTo(angle2);
    }
}

