/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo;

import com.vividsolutions.jts.geom.Point;
import de.datomino.util.geo.AbstractImmutableValidGeoObject;
import java.util.ArrayList;
import java.util.List;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;

public class ImmutablePoint
extends AbstractImmutableValidGeoObject<ImmutablePoint, Point> {
    private transient Coordinate coordinate;

    protected ImmutablePoint(Point point, CoordinateFactory coordinateFactory) {
        super(point, coordinateFactory);
    }

    public ImmutablePoint(Point point, Coordinate c) {
        super(point, c.getFactory());
        this.coordinate = c;
    }

    public Coordinate getCoordinate() {
        if (this.coordinate == null) {
            Point point = (Point)this.getGeometry();
            this.coordinate = this.getCoordinateFactory().createCoordinate(point.getX(), point.getY());
        }
        return this.coordinate;
    }

    @Override
    public List<ImmutablePoint> getCoordinates() {
        ArrayList<ImmutablePoint> points = new ArrayList<ImmutablePoint>(1);
        points.add(this);
        return points;
    }

    @Override
    public ImmutablePoint getAnyPoint() {
        return this;
    }

    @Override
    public double getMinX() {
        Coordinate coordinate = this.getCoordinate();
        double x = coordinate.getX();
        return x;
    }

    @Override
    public double getMaxX() {
        Coordinate coordinate = this.getCoordinate();
        double x = coordinate.getX();
        return x;
    }

    @Override
    public double getMinY() {
        Coordinate coordinate = this.getCoordinate();
        double y = coordinate.getY();
        return y;
    }

    @Override
    public double getMaxY() {
        Coordinate coordinate = this.getCoordinate();
        double y = coordinate.getY();
        return y;
    }

    @Override
    public boolean inBounds(double left, double right, double top, double bottom) {
        Coordinate coordinate = this.getCoordinate();
        double minx = Math.min(left, right);
        double maxx = Math.max(left, right);
        double miny = Math.min(top, bottom);
        double maxy = Math.max(top, bottom);
        double x = coordinate.getX();
        double y = coordinate.getY();
        return minx <= x && maxx >= x && miny <= y && maxy >= y;
    }

    public String toString() {
        Coordinate coordinate = this.getCoordinate();
        return "POINT(" + coordinate.getX() + ", " + coordinate.getY() + ")";
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImmutablePoint) {
            ImmutablePoint other = (ImmutablePoint)obj;
            Coordinate myCoord = this.getCoordinate();
            Coordinate otherCoord = other.getCoordinate();
            return myCoord.equals(otherCoord);
        }
        return false;
    }

    public int hashCode() {
        return this.getCoordinate().hashCode();
    }

    public double getX() {
        return this.getCoordinate().getX();
    }

    public double getY() {
        return this.getCoordinate().getY();
    }
}

