/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo;

import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import de.datomino.util.geo.AbstractImmutableMultiGeom;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.ImmutablePolygonKind;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.ktde.math.projection.CoordinateFactory;

public class ImmutableMultiPolygon
extends AbstractImmutableMultiGeom<ImmutableMultiPolygon, ImmutablePolygon, Polygon, MultiPolygon>
implements ImmutablePolygonKind {
    protected ImmutableMultiPolygon(MultiPolygon geometry, CoordinateFactory coordinateFactory) {
        super(geometry, coordinateFactory);
    }

    private ImmutableMultiPolygon(CoordinateFactory coordinateFactory) {
        super(null, coordinateFactory);
    }

    protected ImmutableMultiPolygon getInstance(CoordinateFactory coordinateFactory) {
        return new ImmutableMultiPolygon(coordinateFactory);
    }

    protected ImmutableMultiPolygon getInstance(CoordinateFactory coordinateFactory, List<ImmutablePolygon> parts) {
        return ImmutableGeoObjectFactory.createImmutableMultiPolygonByParts(coordinateFactory, parts);
    }

    @Override
    public ImmutablePolygonKind buffer(double distance) {
        List parts = this.getParts();
        ArrayList<ImmutablePolygonKind> bufparts = new ArrayList<ImmutablePolygonKind>(parts.size());
        for (ImmutablePolygonKind polygon : parts) {
            bufparts.add((ImmutablePolygonKind)polygon.buffer(distance));
        }
        return this.union(bufparts);
    }

    @Override
    public ImmutablePolygonKind buffer(double distance, int quadrantSegments) {
        List parts = this.getParts();
        ArrayList<ImmutablePolygonKind> bufparts = new ArrayList<ImmutablePolygonKind>(parts.size());
        for (ImmutablePolygonKind polygon : parts) {
            bufparts.add((ImmutablePolygonKind)polygon.buffer(distance, quadrantSegments));
        }
        return this.union(bufparts);
    }

    @Override
    public ImmutablePolygonKind buffer(double distance, int quadrantSegments, int endCapStyle) {
        List parts = this.getParts();
        ArrayList<ImmutablePolygonKind> bufparts = new ArrayList<ImmutablePolygonKind>(parts.size());
        for (ImmutablePolygonKind polygon : parts) {
            bufparts.add((ImmutablePolygonKind)polygon.buffer(distance, quadrantSegments, endCapStyle));
        }
        return this.union(bufparts);
    }

    private ImmutablePolygonKind union(List<ImmutablePolygonKind> bufparts) {
        if (bufparts.isEmpty()) {
            return this;
        }
        Iterator<ImmutablePolygonKind> bufpartsIter = bufparts.iterator();
        ImmutablePolygonKind poly = bufpartsIter.next();
        while (bufpartsIter.hasNext()) {
            poly = (ImmutablePolygonKind)poly.union(bufpartsIter.next());
        }
        return poly;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        List parts = this.getParts();
        int count = 0;
        for (ImmutablePolygon polygon : parts) {
            toStringBuilder.append("part_" + count, polygon);
            ++count;
        }
        return toStringBuilder.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImmutableMultiPolygon) {
            ImmutableMultiPolygon other = (ImmutableMultiPolygon)obj;
            return new EqualsBuilder().append(this.getParts(), other.getParts()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getParts()).toHashCode();
    }
}

